/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo;

import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineState;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface MachineOperates {
    public static final String NAMESPACE_FIELD = "namespace";
    public static final String MACHINE_ID_FIELD = "machineId";
    public static final String LAST_TIMESTAMP_FIELD = "lastTimestamp";
    public static final String INSTANCE_ID_FIELD = "instanceId";
    public static final String DISTRIBUTE_TIME_FIELD = "distributeTime";
    public static final String REVERT_TIME_FIELD = "revertTime";
    public static final String MAX_MACHINE_ID_FIELD = "maxMachineId";

    public static List<? extends Bson> nextMachineIdPipeline(String namespace) {
        return Arrays.asList(Aggregates.match((Bson)Filters.eq((String)NAMESPACE_FIELD, (Object)namespace)), Aggregates.group((Object)"$namespace", (BsonField[])new BsonField[]{Accumulators.max((String)MAX_MACHINE_ID_FIELD, (Object)"$machineId")}));
    }

    public static Document distributeDocument(String namespace, InstanceId instanceId, MachineState nextMachineState) {
        String namespacedMachineId = MachineIdDistributor.namespacedMachineId((String)namespace, (int)nextMachineState.getMachineId());
        return new Document().append("_id", (Object)namespacedMachineId).append(NAMESPACE_FIELD, (Object)namespace).append(MACHINE_ID_FIELD, (Object)nextMachineState.getMachineId()).append(LAST_TIMESTAMP_FIELD, (Object)nextMachineState.getLastTimeStamp()).append(INSTANCE_ID_FIELD, (Object)instanceId.getInstanceId()).append(DISTRIBUTE_TIME_FIELD, (Object)System.currentTimeMillis()).append(REVERT_TIME_FIELD, (Object)0L);
    }

    public static Bson distributeByRevertFilter(String namespace, InstanceId instanceId, Duration safeGuardDuration) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)NAMESPACE_FIELD, (Object)namespace), Filters.or((Bson[])new Bson[]{Filters.eq((String)INSTANCE_ID_FIELD, (Object)""), Filters.lte((String)LAST_TIMESTAMP_FIELD, (Object)MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()))})});
    }

    public static Bson distributeByRevertUpdate(InstanceId instanceId, long lastTimestamp) {
        return Updates.combine((Bson[])new Bson[]{Updates.set((String)INSTANCE_ID_FIELD, (Object)instanceId.getInstanceId()), Updates.set((String)LAST_TIMESTAMP_FIELD, (Object)lastTimestamp)});
    }

    public static Bson distributeBySelfFilter(String namespace, InstanceId instanceId, Duration safeGuardDuration) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)NAMESPACE_FIELD, (Object)namespace), Filters.eq((String)INSTANCE_ID_FIELD, (Object)instanceId.getInstanceId()), Filters.gt((String)LAST_TIMESTAMP_FIELD, (Object)MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()))});
    }

    public static Bson distributeBySelfUpdate(long lastTimestamp) {
        return Updates.set((String)LAST_TIMESTAMP_FIELD, (Object)lastTimestamp);
    }

    public static Bson revertFilter(String namespace, InstanceId instanceId, MachineState machineState) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)MachineIdDistributor.namespacedMachineId((String)namespace, (int)machineState.getMachineId())), Filters.eq((String)INSTANCE_ID_FIELD, (Object)instanceId.getInstanceId())});
    }

    public static Bson revertUpdate(InstanceId instanceId, MachineState machineState) {
        return Updates.combine((Bson[])new Bson[]{Updates.set((String)INSTANCE_ID_FIELD, (Object)(instanceId.isStable() ? instanceId.getInstanceId() : "")), Updates.set((String)REVERT_TIME_FIELD, (Object)System.currentTimeMillis()), Updates.set((String)LAST_TIMESTAMP_FIELD, (Object)machineState.getLastTimeStamp())});
    }

    public static Bson guardFilter(String namespace, InstanceId instanceId, MachineState machineState) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)MachineIdDistributor.namespacedMachineId((String)namespace, (int)machineState.getMachineId())), Filters.eq((String)INSTANCE_ID_FIELD, (Object)instanceId.getInstanceId())});
    }

    public static Bson guardUpdate(long lastTimestamp) {
        return Updates.set((String)LAST_TIMESTAMP_FIELD, (Object)lastTimestamp);
    }
}

