/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter;

import me.ahoo.cosid.accessor.parser.CosIdAccessorParser;
import me.ahoo.cosid.accessor.parser.DefaultAccessorParser;
import me.ahoo.cosid.accessor.parser.FieldDefinitionParser;
import me.ahoo.cosid.accessor.registry.CosIdAccessorRegistry;
import me.ahoo.cosid.accessor.registry.DefaultAccessorRegistry;
import me.ahoo.cosid.annotation.AnnotationDefinitionParser;
import me.ahoo.cosid.provider.DefaultIdGeneratorProvider;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@EnableConfigurationProperties(value={CosIdProperties.class})
public class CosIdAutoConfiguration {
    private final CosIdProperties cosIdProperties;

    public CosIdAutoConfiguration(CosIdProperties cosIdProperties) {
        this.cosIdProperties = cosIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public IdGeneratorProvider idGeneratorProvider() {
        return DefaultIdGeneratorProvider.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    public FieldDefinitionParser fieldDefinitionParser() {
        return AnnotationDefinitionParser.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdAccessorParser cosIdAccessorParser(FieldDefinitionParser definitionParser) {
        return new DefaultAccessorParser(definitionParser);
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdAccessorRegistry cosIdAccessorRegistry(CosIdAccessorParser cosIdAccessorParser) {
        return new DefaultAccessorRegistry(cosIdAccessorParser);
    }
}

