/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import javax.sql.DataSource;
import me.ahoo.cosid.jdbc.JdbcIdSegmentDistributorFactory;
import me.ahoo.cosid.jdbc.JdbcIdSegmentInitializer;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.ConditionalOnCosIdSegmentEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSegmentEnabled
@EnableConfigurationProperties(value={SegmentIdProperties.class})
@ConditionalOnProperty(value={"cosid.segment.distributor.type"}, matchIfMissing=true, havingValue="jdbc")
public class CosIdJdbcSegmentAutoConfiguration {
    private final SegmentIdProperties segmentIdProperties;

    public CosIdJdbcSegmentAutoConfiguration(SegmentIdProperties segmentIdProperties) {
        this.segmentIdProperties = segmentIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public JdbcIdSegmentInitializer jdbcIdSegmentInitializer(DataSource dataSource) {
        SegmentIdProperties.Distributor.Jdbc jdbc = this.segmentIdProperties.getDistributor().getJdbc();
        JdbcIdSegmentInitializer segmentInitializer = new JdbcIdSegmentInitializer(jdbc.getInitCosidTableSql(), jdbc.getInitIdSegmentSql(), dataSource);
        if (jdbc.isEnableAutoInitCosidTable()) {
            segmentInitializer.tryInitCosIdTable();
        }
        return segmentInitializer;
    }

    @Bean
    @ConditionalOnMissingBean
    public IdSegmentDistributorFactory idSegmentDistributorFactory(DataSource dataSource, JdbcIdSegmentInitializer jdbcIdSegmentInitializer) {
        SegmentIdProperties.Distributor.Jdbc jdbc = this.segmentIdProperties.getDistributor().getJdbc();
        return new JdbcIdSegmentDistributorFactory(dataSource, jdbc.isEnableAutoInitIdSegment(), jdbcIdSegmentInitializer, jdbc.getIncrementMaxIdSql(), jdbc.getFetchMaxIdSql());
    }
}

