/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import me.ahoo.cosid.proxy.ProxyIdSegmentDistributorFactory;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.segment.ConditionalOnCosIdSegmentEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSegmentEnabled
@EnableConfigurationProperties(value={SegmentIdProperties.class})
@ConditionalOnProperty(value={"cosid.segment.distributor.type"}, matchIfMissing=true, havingValue="proxy")
public class CosIdProxySegmentAutoConfiguration {
    private final CosIdProperties cosIdProperties;

    public CosIdProxySegmentAutoConfiguration(CosIdProperties cosIdProperties) {
        this.cosIdProperties = cosIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().build();
    }

    @Bean
    @ConditionalOnMissingBean
    public IdSegmentDistributorFactory idSegmentDistributorFactory(OkHttpClient httpClient) {
        return new ProxyIdSegmentDistributorFactory(httpClient, this.cosIdProperties.getProxy().getHost());
    }
}

