/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import java.time.Duration;
import me.ahoo.cosid.redis.RedisIdSegmentDistributor;
import me.ahoo.cosid.redis.RedisIdSegmentDistributorFactory;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.ConditionalOnCosIdSegmentEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import me.ahoo.cosky.core.redis.RedisConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSegmentEnabled
@EnableConfigurationProperties(value={SegmentIdProperties.class})
@ConditionalOnClass(value={RedisIdSegmentDistributor.class})
@ConditionalOnProperty(value={"cosid.segment.distributor.type"}, matchIfMissing=true, havingValue="redis")
public class CosIdRedisSegmentAutoConfiguration {
    private final SegmentIdProperties segmentIdProperties;

    public CosIdRedisSegmentAutoConfiguration(SegmentIdProperties segmentIdProperties) {
        this.segmentIdProperties = segmentIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public IdSegmentDistributorFactory idSegmentDistributorFactory(RedisConnectionFactory connectionFactory) {
        Duration timeout = this.segmentIdProperties.getDistributor().getRedis().getTimeout();
        return new RedisIdSegmentDistributorFactory(connectionFactory, timeout);
    }
}

