/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.converter.PrefixIdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.segment.DefaultSegmentId;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.SegmentChainId;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.segment.StringSegmentId;
import me.ahoo.cosid.segment.concurrent.PrefetchWorkerExecutorService;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.segment.ConditionalOnCosIdSegmentEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.CosIdLifecyclePrefetchWorkerExecutorService;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSegmentEnabled
@EnableConfigurationProperties(value={SegmentIdProperties.class})
public class CosIdSegmentAutoConfiguration {
    private final CosIdProperties cosIdProperties;
    private final SegmentIdProperties segmentIdProperties;

    public CosIdSegmentAutoConfiguration(CosIdProperties cosIdProperties, SegmentIdProperties segmentIdProperties) {
        this.cosIdProperties = cosIdProperties;
        this.segmentIdProperties = segmentIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public PrefetchWorkerExecutorService prefetchWorkerExecutorService() {
        SegmentIdProperties.Chain.PrefetchWorker prefetchWorker = this.segmentIdProperties.getChain().getPrefetchWorker();
        Preconditions.checkNotNull((Object)prefetchWorker, (Object)"cosid.segment.chain.prefetch-worker can not be null!");
        return new PrefetchWorkerExecutorService(prefetchWorker.getPrefetchPeriod(), prefetchWorker.getCorePoolSize(), prefetchWorker.isShutdownHook());
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdLifecyclePrefetchWorkerExecutorService lifecycleSegmentChainId(PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        return new CosIdLifecyclePrefetchWorkerExecutorService(prefetchWorkerExecutorService);
    }

    private IdSegmentDistributorDefinition asDistributorDefinition(String name, SegmentIdProperties.IdDefinition idDefinition) {
        return new IdSegmentDistributorDefinition(this.cosIdProperties.getNamespace(), name, idDefinition.getOffset(), idDefinition.getStep());
    }

    @Bean
    @ConditionalOnMissingBean
    public SegmentId shareSegmentId(IdSegmentDistributorFactory distributorFactory, IdGeneratorProvider idGeneratorProvider, PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        SegmentIdProperties.IdDefinition shareIdDefinition = this.segmentIdProperties.getShare();
        IdSegmentDistributorDefinition shareDistributorDefinition = this.asDistributorDefinition("__share__", shareIdDefinition);
        IdSegmentDistributor shareIdSegmentDistributor = distributorFactory.create(shareDistributorDefinition);
        SegmentId shareIdGen = CosIdSegmentAutoConfiguration.createSegment(this.segmentIdProperties, shareIdDefinition, shareIdSegmentDistributor, prefetchWorkerExecutorService);
        if (Objects.isNull(idGeneratorProvider.getShare())) {
            idGeneratorProvider.setShare((IdGenerator)shareIdGen);
        }
        if (this.segmentIdProperties.getProvider().isEmpty()) {
            return shareIdGen;
        }
        this.segmentIdProperties.getProvider().forEach((name, idDefinition) -> {
            IdSegmentDistributorDefinition distributorDefinition = this.asDistributorDefinition((String)name, shareIdDefinition);
            IdSegmentDistributor idSegmentDistributor = distributorFactory.create(distributorDefinition);
            SegmentId idGenerator = CosIdSegmentAutoConfiguration.createSegment(this.segmentIdProperties, idDefinition, idSegmentDistributor, prefetchWorkerExecutorService);
            idGeneratorProvider.set(name, (IdGenerator)idGenerator);
        });
        return shareIdGen;
    }

    private static SegmentId createSegment(SegmentIdProperties segmentIdProperties, SegmentIdProperties.IdDefinition idDefinition, IdSegmentDistributor idSegmentDistributor, PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        DefaultSegmentId segmentId;
        long ttl = (Long)MoreObjects.firstNonNull((Object)idDefinition.getTtl(), (Object)segmentIdProperties.getTtl());
        SegmentIdProperties.Mode mode = (SegmentIdProperties.Mode)((Object)MoreObjects.firstNonNull((Object)((Object)idDefinition.getMode()), (Object)((Object)segmentIdProperties.getMode())));
        if (SegmentIdProperties.Mode.DEFAULT.equals((Object)mode)) {
            segmentId = new DefaultSegmentId(ttl, idSegmentDistributor);
        } else {
            SegmentIdProperties.Chain chain = (SegmentIdProperties.Chain)MoreObjects.firstNonNull((Object)idDefinition.getChain(), (Object)segmentIdProperties.getChain());
            segmentId = new SegmentChainId(ttl, chain.getSafeDistance(), idSegmentDistributor, prefetchWorkerExecutorService);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        IdConverter idConverter = ToStringIdConverter.INSTANCE;
        switch (converterDefinition.getType()) {
            case TO_STRING: {
                break;
            }
            case RADIX: {
                IdConverterDefinition.Radix radix = converterDefinition.getRadix();
                idConverter = Radix62IdConverter.of((boolean)radix.isPadStart(), (int)radix.getCharSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)converterDefinition.getType()));
            }
        }
        if (!"".equals(converterDefinition.getPrefix())) {
            idConverter = new PrefixIdConverter(converterDefinition.getPrefix(), idConverter);
        }
        return new StringSegmentId((SegmentId)segmentId, idConverter);
    }
}

