/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import com.google.common.base.Preconditions;
import java.time.Duration;
import me.ahoo.cosid.redis.RedisMachineIdDistributor;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.snowflake.ConditionalOnCosIdSnowflakeEnabled;
import me.ahoo.cosid.spring.boot.starter.snowflake.SnowflakeIdProperties;
import me.ahoo.cosky.core.redis.RedisConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSnowflakeEnabled
@ConditionalOnClass(value={RedisMachineIdDistributor.class})
@ConditionalOnProperty(value={"cosid.snowflake.machine.distributor.type"}, havingValue="redis")
public class CosIdRedisMachineIdDistributorAutoConfiguration {
    private final SnowflakeIdProperties snowflakeIdProperties;

    public CosIdRedisMachineIdDistributorAutoConfiguration(SnowflakeIdProperties snowflakeIdProperties) {
        this.snowflakeIdProperties = snowflakeIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public RedisMachineIdDistributor redisMachineIdDistributor(RedisConnectionFactory redisConnectionFactory, MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        Preconditions.checkNotNull((Object)redisConnectionFactory, (Object)"redisConnectionFactory can not be null.");
        Duration timeout = this.snowflakeIdProperties.getMachine().getDistributor().getRedis().getTimeout();
        return new RedisMachineIdDistributor(timeout, redisConnectionFactory.getShareReactiveCommands(), localMachineState, clockBackwardsSynchronizer);
    }
}

