/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Objects;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.converter.PrefixIdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SnowflakeFriendlyIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.ClockSyncSnowflakeId;
import me.ahoo.cosid.snowflake.DefaultClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.DefaultSnowflakeFriendlyId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.StringSnowflakeId;
import me.ahoo.cosid.snowflake.machine.DefaultMachineIdGuarder;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.LocalMachineStateStorage;
import me.ahoo.cosid.snowflake.machine.MachineId;
import me.ahoo.cosid.snowflake.machine.MachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.MachineIdGuarder;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import me.ahoo.cosid.snowflake.machine.ManualMachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.k8s.StatefulSetMachineIdDistributor;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.snowflake.ConditionalOnCosIdSnowflakeEnabled;
import me.ahoo.cosid.spring.boot.starter.snowflake.CosIdLifecycleMachineIdDistributor;
import me.ahoo.cosid.spring.boot.starter.snowflake.CosIdLifecycleMachineIdGuarder;
import me.ahoo.cosid.spring.boot.starter.snowflake.SnowflakeIdProperties;
import me.ahoo.cosid.util.ProcessId;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSnowflakeEnabled
@EnableConfigurationProperties(value={SnowflakeIdProperties.class})
public class CosIdSnowflakeAutoConfiguration {
    private final CosIdProperties cosIdProperties;
    private final SnowflakeIdProperties snowflakeIdProperties;

    public CosIdSnowflakeAutoConfiguration(CosIdProperties cosIdProperties, SnowflakeIdProperties snowflakeIdProperties) {
        this.cosIdProperties = cosIdProperties;
        this.snowflakeIdProperties = snowflakeIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceId instanceId(InetUtils inetUtils) {
        SnowflakeIdProperties.Machine machine = this.snowflakeIdProperties.getMachine();
        Preconditions.checkNotNull((Object)machine, (Object)"cosid.snowflake.machine can not be null.");
        boolean stable = false;
        if (Objects.nonNull(machine.getStable()) && machine.getStable().booleanValue()) {
            stable = machine.getStable();
        }
        if (!Strings.isNullOrEmpty((String)machine.getInstanceId())) {
            return InstanceId.of((String)machine.getInstanceId(), (boolean)stable);
        }
        InetUtils.HostInfo hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        int port = ProcessId.CURRENT.getProcessId();
        if (Objects.nonNull(machine.getPort()) && machine.getPort() > 0) {
            port = machine.getPort();
        }
        return InstanceId.of((String)hostInfo.getIpAddress(), (int)port, (boolean)stable);
    }

    @Bean
    @ConditionalOnMissingBean
    public MachineStateStorage localMachineState() {
        if (!this.snowflakeIdProperties.getMachine().getStateStorage().isEnabled()) {
            return MachineStateStorage.NONE;
        }
        return new LocalMachineStateStorage(this.snowflakeIdProperties.getMachine().getStateStorage().getLocal().getStateLocation());
    }

    @Bean
    @ConditionalOnMissingBean
    public ClockBackwardsSynchronizer clockBackwardsSynchronizer() {
        SnowflakeIdProperties.ClockBackwards clockBackwards = this.snowflakeIdProperties.getClockBackwards();
        Preconditions.checkNotNull((Object)clockBackwards, (Object)"cosid.snowflake.clockBackwards can not be null.");
        return new DefaultClockBackwardsSynchronizer(clockBackwards.getSpinThreshold(), clockBackwards.getBrokenThreshold());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cosid.snowflake.machine.distributor.type"}, matchIfMissing=true, havingValue="manual")
    public ManualMachineIdDistributor machineIdDistributor(MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        SnowflakeIdProperties.Machine.Manual manual = this.snowflakeIdProperties.getMachine().getDistributor().getManual();
        Preconditions.checkNotNull((Object)manual, (Object)"cosid.snowflake.machine.distributor.manual can not be null.");
        Integer machineId = manual.getMachineId();
        Preconditions.checkNotNull((Object)machineId, (Object)"cosid.snowflake.machine.distributor.manual.machineId can not be null.");
        Preconditions.checkArgument((machineId >= 0 ? 1 : 0) != 0, (Object)"cosid.snowflake.machine.distributor.manual.machineId can not be less than 0.");
        return new ManualMachineIdDistributor(machineId.intValue(), localMachineState, clockBackwardsSynchronizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cosid.snowflake.machine.distributor.type"}, havingValue="stateful_set")
    public StatefulSetMachineIdDistributor statefulSetMachineIdDistributor(MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        return new StatefulSetMachineIdDistributor(localMachineState, clockBackwardsSynchronizer);
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdLifecycleMachineIdDistributor cosIdLifecycleMachineIdDistributor(InstanceId instanceId, MachineIdDistributor machineIdDistributor) {
        return new CosIdLifecycleMachineIdDistributor(this.cosIdProperties, instanceId, machineIdDistributor);
    }

    private Duration getSafeGuardDuration() {
        SnowflakeIdProperties.Machine.Guarder guarder = this.snowflakeIdProperties.getMachine().getGuarder();
        if (guarder.isEnabled()) {
            return guarder.getSafeGuardDuration();
        }
        return MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION;
    }

    @Bean
    @ConditionalOnMissingBean
    public MachineIdGuarder machineIdGuarder(MachineIdDistributor machineIdDistributor) {
        SnowflakeIdProperties.Machine.Guarder guarder = this.snowflakeIdProperties.getMachine().getGuarder();
        if (!guarder.isEnabled()) {
            return MachineIdGuarder.NONE;
        }
        return new DefaultMachineIdGuarder(machineIdDistributor, DefaultMachineIdGuarder.executorService(), guarder.getInitialDelay(), guarder.getDelay(), this.getSafeGuardDuration());
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdLifecycleMachineIdGuarder cosIdLifecycleMachineIdGuarder(InstanceId instanceId, MachineIdGuarder machineIdGuarder) {
        return new CosIdLifecycleMachineIdGuarder(this.cosIdProperties, instanceId, machineIdGuarder);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public SnowflakeId shareSnowflakeId(MachineIdDistributor machineIdDistributor, InstanceId instanceId, IdGeneratorProvider idGeneratorProvider, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        SnowflakeIdProperties.IdDefinition shareIdDefinition = this.snowflakeIdProperties.getShare();
        SnowflakeId shareIdGen = this.createIdGen(machineIdDistributor, instanceId, shareIdDefinition, clockBackwardsSynchronizer);
        idGeneratorProvider.setShare((IdGenerator)shareIdGen);
        if (this.snowflakeIdProperties.getProvider().isEmpty()) {
            return shareIdGen;
        }
        this.snowflakeIdProperties.getProvider().forEach((name, idDefinition) -> {
            SnowflakeId idGenerator = this.createIdGen(machineIdDistributor, instanceId, (SnowflakeIdProperties.IdDefinition)idDefinition, clockBackwardsSynchronizer);
            idGeneratorProvider.set(name, (IdGenerator)idGenerator);
        });
        return shareIdGen;
    }

    @Bean
    @ConditionalOnBean(value={SnowflakeId.class})
    public MachineId machineId(SnowflakeId snowflakeId) {
        long machineId = snowflakeId.getMachineId();
        return new MachineId(machineId);
    }

    private SnowflakeId createIdGen(MachineIdDistributor machineIdDistributor, InstanceId instanceId, SnowflakeIdProperties.IdDefinition idDefinition, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        long epoch = this.getEpoch(idDefinition);
        Integer machineBit = this.getMachineBit(idDefinition);
        int machineId = machineIdDistributor.distribute(this.cosIdProperties.getNamespace(), machineBit.intValue(), instanceId, this.getSafeGuardDuration()).getMachineId();
        Object snowflakeId = SnowflakeIdProperties.IdDefinition.TimestampUnit.SECOND.equals((Object)idDefinition.getTimestampUnit()) ? new SecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit.intValue(), idDefinition.getSequenceBit(), (long)machineId) : new MillisecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit.intValue(), idDefinition.getSequenceBit(), (long)machineId);
        if (idDefinition.isClockSync()) {
            snowflakeId = new ClockSyncSnowflakeId((SnowflakeId)snowflakeId, clockBackwardsSynchronizer);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        ZoneId zoneId = ZoneId.of(this.snowflakeIdProperties.getZoneId());
        IdConverter idConverter = ToStringIdConverter.INSTANCE;
        switch (converterDefinition.getType()) {
            case TO_STRING: {
                break;
            }
            case SNOWFLAKE_FRIENDLY: {
                idConverter = new SnowflakeFriendlyIdConverter(SnowflakeIdStateParser.of((SnowflakeId)snowflakeId, (ZoneId)zoneId));
                break;
            }
            case RADIX: {
                IdConverterDefinition.Radix radix = converterDefinition.getRadix();
                idConverter = Radix62IdConverter.of((boolean)radix.isPadStart(), (int)radix.getCharSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)converterDefinition.getType()));
            }
        }
        if (!"".equals(converterDefinition.getPrefix())) {
            idConverter = new PrefixIdConverter(converterDefinition.getPrefix(), idConverter);
        }
        if (idDefinition.isFriendly()) {
            SnowflakeIdStateParser snowflakeIdStateParser = SnowflakeIdStateParser.of((SnowflakeId)snowflakeId, (ZoneId)zoneId);
            return new DefaultSnowflakeFriendlyId((SnowflakeId)snowflakeId, idConverter, snowflakeIdStateParser);
        }
        return new StringSnowflakeId((SnowflakeId)snowflakeId, idConverter);
    }

    private Integer getMachineBit(SnowflakeIdProperties.IdDefinition idDefinition) {
        Integer machineBit = idDefinition.getMachineBit();
        if (Objects.isNull(machineBit) || machineBit <= 0) {
            machineBit = this.snowflakeIdProperties.getMachine().getMachineBit();
        }
        return machineBit;
    }

    private long getEpoch(SnowflakeIdProperties.IdDefinition idDefinition) {
        if (idDefinition.getEpoch() > 0L) {
            return idDefinition.getEpoch();
        }
        return this.snowflakeIdProperties.getEpoch();
    }
}

