/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import java.time.Duration;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ahoo.cosid.snowflake.machine.DefaultMachineIdGuarder;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="cosid.snowflake")
public class SnowflakeIdProperties {
    public static final String PREFIX = "cosid.snowflake";
    private boolean enabled = false;
    private String zoneId = ZoneId.systemDefault().getId();
    private long epoch = 1577203200000L;
    private Machine machine;
    private ClockBackwards clockBackwards;
    private IdDefinition share = new IdDefinition();
    private Map<String, IdDefinition> provider;

    public SnowflakeIdProperties() {
        this.machine = new Machine();
        this.clockBackwards = new ClockBackwards();
        this.provider = new HashMap<String, IdDefinition>();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public ClockBackwards getClockBackwards() {
        return this.clockBackwards;
    }

    public void setClockBackwards(ClockBackwards clockBackwards) {
        this.clockBackwards = clockBackwards;
    }

    public IdDefinition getShare() {
        return this.share;
    }

    public void setShare(IdDefinition share) {
        this.share = share;
    }

    @Nonnull
    public Map<String, IdDefinition> getProvider() {
        return this.provider;
    }

    public void setProvider(Map<String, IdDefinition> provider) {
        this.provider = provider;
    }

    public static class ClockBackwards {
        private int spinThreshold = 1;
        private int brokenThreshold = 500;

        public int getSpinThreshold() {
            return this.spinThreshold;
        }

        public void setSpinThreshold(int spinThreshold) {
            this.spinThreshold = spinThreshold;
        }

        public int getBrokenThreshold() {
            return this.brokenThreshold;
        }

        public void setBrokenThreshold(int brokenThreshold) {
            this.brokenThreshold = brokenThreshold;
        }
    }

    public static class IdDefinition {
        private boolean clockSync = true;
        private boolean friendly = true;
        private TimestampUnit timestampUnit = TimestampUnit.MILLISECOND;
        private long epoch;
        private int timestampBit = 41;
        private Integer machineBit;
        private int sequenceBit = 12;
        @NestedConfigurationProperty
        private IdConverterDefinition converter = new IdConverterDefinition();

        public boolean isClockSync() {
            return this.clockSync;
        }

        public void setClockSync(boolean clockSync) {
            this.clockSync = clockSync;
        }

        public boolean isFriendly() {
            return this.friendly;
        }

        public void setFriendly(boolean friendly) {
            this.friendly = friendly;
        }

        public TimestampUnit getTimestampUnit() {
            return this.timestampUnit;
        }

        public void setTimestampUnit(TimestampUnit timestampUnit) {
            this.timestampUnit = timestampUnit;
        }

        public long getEpoch() {
            return this.epoch;
        }

        public void setEpoch(long epoch) {
            this.epoch = epoch;
        }

        public int getTimestampBit() {
            return this.timestampBit;
        }

        public void setTimestampBit(int timestampBit) {
            this.timestampBit = timestampBit;
        }

        public Integer getMachineBit() {
            return this.machineBit;
        }

        public void setMachineBit(Integer machineBit) {
            this.machineBit = machineBit;
        }

        public int getSequenceBit() {
            return this.sequenceBit;
        }

        public void setSequenceBit(int sequenceBit) {
            this.sequenceBit = sequenceBit;
        }

        public IdConverterDefinition getConverter() {
            return this.converter;
        }

        public void setConverter(IdConverterDefinition converter) {
            this.converter = converter;
        }

        public static enum TimestampUnit {
            SECOND,
            MILLISECOND;

        }
    }

    public static class Machine {
        private Boolean stable;
        private Integer port;
        private String instanceId;
        private int machineBit = 10;
        private StateStorage stateStorage = new StateStorage();
        private Distributor distributor = new Distributor();
        private Guarder guarder = new Guarder();

        public Boolean getStable() {
            return this.stable;
        }

        public void setStable(Boolean stable) {
            this.stable = stable;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public int getMachineBit() {
            return this.machineBit;
        }

        public void setMachineBit(int machineBit) {
            this.machineBit = machineBit;
        }

        public StateStorage getStateStorage() {
            return this.stateStorage;
        }

        public void setStateStorage(StateStorage stateStorage) {
            this.stateStorage = stateStorage;
        }

        public Distributor getDistributor() {
            return this.distributor;
        }

        public void setDistributor(Distributor distributor) {
            this.distributor = distributor;
        }

        public Guarder getGuarder() {
            return this.guarder;
        }

        public Machine setGuarder(Guarder guarder) {
            this.guarder = guarder;
            return this;
        }

        public static class Guarder {
            private boolean enabled = false;
            private Duration initialDelay = DefaultMachineIdGuarder.DEFAULT_INITIAL_DELAY;
            private Duration delay = DefaultMachineIdGuarder.DEFAULT_DELAY;
            private Duration safeGuardDuration = Duration.ofMinutes(5L);

            public boolean isEnabled() {
                return this.enabled;
            }

            public Guarder setEnabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Duration getInitialDelay() {
                return this.initialDelay;
            }

            public Guarder setInitialDelay(Duration initialDelay) {
                this.initialDelay = initialDelay;
                return this;
            }

            public Duration getDelay() {
                return this.delay;
            }

            public Guarder setDelay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Duration getSafeGuardDuration() {
                return this.safeGuardDuration;
            }

            public Guarder setSafeGuardDuration(Duration safeGuardDuration) {
                this.safeGuardDuration = safeGuardDuration;
                return this;
            }
        }

        public static class Redis {
            private Duration timeout = Duration.ofSeconds(1L);

            public Duration getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Duration timeout) {
                this.timeout = timeout;
            }
        }

        public static class Manual {
            private Integer machineId;

            public Integer getMachineId() {
                return this.machineId;
            }

            public void setMachineId(Integer machineId) {
                this.machineId = machineId;
            }
        }

        public static class Distributor {
            public static final String TYPE = "cosid.snowflake.machine.distributor.type";
            private Type type = Type.MANUAL;
            private Manual manual;
            private Redis redis = new Redis();

            public Type getType() {
                return this.type;
            }

            public void setType(Type type) {
                this.type = type;
            }

            public Manual getManual() {
                return this.manual;
            }

            public void setManual(Manual manual) {
                this.manual = manual;
            }

            public Redis getRedis() {
                return this.redis;
            }

            public void setRedis(Redis redis) {
                this.redis = redis;
            }

            public static enum Type {
                MANUAL,
                STATEFUL_SET,
                JDBC,
                REDIS,
                ZOOKEEPER,
                PROXY;

            }
        }

        public static class StateStorage {
            private boolean enabled = true;
            private Local local = new Local();

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public Local getLocal() {
                return this.local;
            }

            public void setLocal(Local local) {
                this.local = local;
            }

            public static class Local {
                private String stateLocation = "./cosid-machine-state/";

                public String getStateLocation() {
                    return this.stateLocation;
                }

                public void setStateLocation(String stateLocation) {
                    this.stateLocation = stateLocation;
                }
            }
        }
    }
}

