/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.cosid;

import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.cosid.ClockSyncCosIdGenerator;
import me.ahoo.cosid.cosid.CosIdGenerator;
import me.ahoo.cosid.cosid.Radix36CosIdGenerator;
import me.ahoo.cosid.cosid.Radix62CosIdGenerator;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdGuarder;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.Namespaces;
import me.ahoo.cosid.spring.boot.starter.cosid.ConditionalOnCosIdGeneratorEnabled;
import me.ahoo.cosid.spring.boot.starter.cosid.CosIdGeneratorProperties;
import me.ahoo.cosid.spring.boot.starter.machine.MachineProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdGeneratorEnabled
@EnableConfigurationProperties(value={CosIdGeneratorProperties.class})
public class CosIdGeneratorAutoConfiguration {
    private final CosIdProperties cosIdProperties;
    private final MachineProperties machineProperties;
    private final CosIdGeneratorProperties cosIdGeneratorProperties;

    public CosIdGeneratorAutoConfiguration(CosIdProperties cosIdProperties, MachineProperties machineProperties, CosIdGeneratorProperties cosIdGeneratorProperties) {
        this.cosIdProperties = cosIdProperties;
        this.machineProperties = machineProperties;
        this.cosIdGeneratorProperties = cosIdGeneratorProperties;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public CosIdGenerator cosIdGenerator(MachineIdDistributor machineIdDistributor, MachineIdGuarder machineIdGuarder, InstanceId instanceId, IdGeneratorProvider idGeneratorProvider, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        Radix62CosIdGenerator cosIdGenerator;
        String namespace = Namespaces.firstNotBlank(this.cosIdGeneratorProperties.getNamespace(), this.cosIdProperties.getNamespace());
        int machineId = machineIdDistributor.distribute(namespace, this.cosIdGeneratorProperties.getMachineBit(), instanceId, this.machineProperties.getSafeGuardDuration()).getMachineId();
        machineIdGuarder.register(namespace, instanceId);
        switch (this.cosIdGeneratorProperties.getType()) {
            case RADIX62: {
                cosIdGenerator = new Radix62CosIdGenerator(this.cosIdGeneratorProperties.getTimestampBit(), this.cosIdGeneratorProperties.getMachineBit(), this.cosIdGeneratorProperties.getSequenceBit(), machineId, this.cosIdGeneratorProperties.getSequenceResetThreshold());
                break;
            }
            case RADIX36: {
                cosIdGenerator = new Radix36CosIdGenerator(this.cosIdGeneratorProperties.getTimestampBit(), this.cosIdGeneratorProperties.getMachineBit(), this.cosIdGeneratorProperties.getSequenceBit(), machineId, this.cosIdGeneratorProperties.getSequenceResetThreshold());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.cosIdGeneratorProperties.getType()));
            }
        }
        ClockSyncCosIdGenerator clockSyncCosIdGenerator = new ClockSyncCosIdGenerator((CosIdGenerator)cosIdGenerator, clockBackwardsSynchronizer);
        idGeneratorProvider.set("cosid", (IdGenerator)clockSyncCosIdGenerator);
        return clockSyncCosIdGenerator;
    }
}

