/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import lombok.Generated;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.converter.PrefixIdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SuffixIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.segment.DefaultSegmentId;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.SegmentChainId;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.segment.StringSegmentId;
import me.ahoo.cosid.segment.concurrent.PrefetchWorkerExecutorService;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.Namespaces;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;

public class SegmentIdBeanRegistrar
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentIdBeanRegistrar.class);
    private final CosIdProperties cosIdProperties;
    private final SegmentIdProperties segmentIdProperties;
    private final IdSegmentDistributorFactory distributorFactory;
    private final IdGeneratorProvider idGeneratorProvider;
    private final PrefetchWorkerExecutorService prefetchWorkerExecutorService;
    private final ConfigurableApplicationContext applicationContext;

    public SegmentIdBeanRegistrar(CosIdProperties cosIdProperties, SegmentIdProperties segmentIdProperties, IdSegmentDistributorFactory distributorFactory, IdGeneratorProvider idGeneratorProvider, PrefetchWorkerExecutorService prefetchWorkerExecutorService, ConfigurableApplicationContext applicationContext) {
        this.cosIdProperties = cosIdProperties;
        this.segmentIdProperties = segmentIdProperties;
        this.distributorFactory = distributorFactory;
        this.idGeneratorProvider = idGeneratorProvider;
        this.prefetchWorkerExecutorService = prefetchWorkerExecutorService;
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.register();
    }

    public void register() {
        SegmentIdProperties.ShardIdDefinition shareIdDefinition = this.segmentIdProperties.getShare();
        if (shareIdDefinition.isEnabled()) {
            this.registerIdDefinition("__share__", shareIdDefinition);
        }
        this.segmentIdProperties.getProvider().forEach(this::registerIdDefinition);
    }

    private void registerIdDefinition(String name, SegmentIdProperties.IdDefinition idDefinition) {
        IdSegmentDistributorDefinition distributorDefinition = this.asDistributorDefinition(name, idDefinition);
        IdSegmentDistributor idSegmentDistributor = this.distributorFactory.create(distributorDefinition);
        SegmentId idGenerator = SegmentIdBeanRegistrar.createSegment(this.segmentIdProperties, idDefinition, idSegmentDistributor, this.prefetchWorkerExecutorService);
        this.registerSegmentId(name, idGenerator);
    }

    private void registerSegmentId(String name, SegmentId segmentId) {
        if (!this.idGeneratorProvider.get(name).isPresent()) {
            this.idGeneratorProvider.set(name, (IdGenerator)segmentId);
        }
        String beanName = name + "SegmentId";
        this.applicationContext.getBeanFactory().registerSingleton(beanName, (Object)segmentId);
    }

    private IdSegmentDistributorDefinition asDistributorDefinition(String name, SegmentIdProperties.IdDefinition idDefinition) {
        String namespace = Namespaces.firstNotBlank(idDefinition.getNamespace(), this.cosIdProperties.getNamespace());
        return new IdSegmentDistributorDefinition(namespace, name, idDefinition.getOffset(), idDefinition.getStep());
    }

    private static SegmentId createSegment(SegmentIdProperties segmentIdProperties, SegmentIdProperties.IdDefinition idDefinition, IdSegmentDistributor idSegmentDistributor, PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        DefaultSegmentId segmentId;
        long ttl = (Long)MoreObjects.firstNonNull((Object)idDefinition.getTtl(), (Object)segmentIdProperties.getTtl());
        SegmentIdProperties.Mode mode = (SegmentIdProperties.Mode)((Object)MoreObjects.firstNonNull((Object)((Object)idDefinition.getMode()), (Object)((Object)segmentIdProperties.getMode())));
        if (SegmentIdProperties.Mode.SEGMENT.equals((Object)mode)) {
            segmentId = new DefaultSegmentId(ttl, idSegmentDistributor);
        } else {
            SegmentIdProperties.Chain chain = (SegmentIdProperties.Chain)MoreObjects.firstNonNull((Object)idDefinition.getChain(), (Object)segmentIdProperties.getChain());
            segmentId = new SegmentChainId(ttl, chain.getSafeDistance(), idSegmentDistributor, prefetchWorkerExecutorService);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        ToStringIdConverter idConverter = ToStringIdConverter.INSTANCE;
        switch (converterDefinition.getType()) {
            case TO_STRING: {
                IdConverterDefinition.ToString toString = converterDefinition.getToString();
                if (toString == null) break;
                idConverter = new ToStringIdConverter(toString.isPadStart(), toString.getCharSize());
                break;
            }
            case RADIX: {
                IdConverterDefinition.Radix radix = converterDefinition.getRadix();
                idConverter = Radix62IdConverter.of((boolean)radix.isPadStart(), (int)radix.getCharSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)converterDefinition.getType()));
            }
        }
        if (!Strings.isNullOrEmpty((String)converterDefinition.getPrefix())) {
            idConverter = new PrefixIdConverter(converterDefinition.getPrefix(), (IdConverter)idConverter);
        }
        if (!Strings.isNullOrEmpty((String)converterDefinition.getSuffix())) {
            idConverter = new SuffixIdConverter(converterDefinition.getSuffix(), (IdConverter)idConverter);
        }
        return new StringSegmentId((SegmentId)segmentId, (IdConverter)idConverter);
    }
}

