/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.time.ZoneId;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.converter.PrefixIdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SnowflakeFriendlyIdConverter;
import me.ahoo.cosid.converter.SuffixIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.snowflake.ClockSyncSnowflakeId;
import me.ahoo.cosid.snowflake.DefaultSnowflakeFriendlyId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.StringSnowflakeId;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.Namespaces;
import me.ahoo.cosid.spring.boot.starter.machine.MachineProperties;
import me.ahoo.cosid.spring.boot.starter.snowflake.SnowflakeIdProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;

public class SnowflakeIdBeanRegistrar
implements InitializingBean {
    private final CosIdProperties cosIdProperties;
    private final MachineProperties machineProperties;
    private final SnowflakeIdProperties snowflakeIdProperties;
    private final InstanceId instanceId;
    private final IdGeneratorProvider idGeneratorProvider;
    private final MachineIdDistributor machineIdDistributor;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;
    private final ConfigurableApplicationContext applicationContext;

    public SnowflakeIdBeanRegistrar(CosIdProperties cosIdProperties, MachineProperties machineProperties, SnowflakeIdProperties snowflakeIdProperties, InstanceId instanceId, IdGeneratorProvider idGeneratorProvider, MachineIdDistributor machineIdDistributor, ClockBackwardsSynchronizer clockBackwardsSynchronizer, ConfigurableApplicationContext applicationContext) {
        this.cosIdProperties = cosIdProperties;
        this.machineProperties = machineProperties;
        this.snowflakeIdProperties = snowflakeIdProperties;
        this.instanceId = instanceId;
        this.idGeneratorProvider = idGeneratorProvider;
        this.machineIdDistributor = machineIdDistributor;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.register();
    }

    public void register() {
        SnowflakeIdProperties.ShardIdDefinition shareIdDefinition = this.snowflakeIdProperties.getShare();
        if (shareIdDefinition.isEnabled()) {
            this.registerIdDefinition("__share__", shareIdDefinition);
        }
        this.snowflakeIdProperties.getProvider().forEach(this::registerIdDefinition);
    }

    private void registerIdDefinition(String name, SnowflakeIdProperties.IdDefinition idDefinition) {
        SnowflakeId idGenerator = this.createIdGen(idDefinition, this.clockBackwardsSynchronizer);
        this.registerSnowflakeId(name, idGenerator);
    }

    private void registerSnowflakeId(String name, SnowflakeId snowflakeId) {
        if (!this.idGeneratorProvider.get(name).isPresent()) {
            this.idGeneratorProvider.set(name, (IdGenerator)snowflakeId);
        }
        String beanName = name + "SnowflakeId";
        this.applicationContext.getBeanFactory().registerSingleton(beanName, (Object)snowflakeId);
    }

    private SnowflakeId createIdGen(SnowflakeIdProperties.IdDefinition idDefinition, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        long epoch = this.getEpoch(idDefinition);
        int machineBit = (Integer)MoreObjects.firstNonNull((Object)idDefinition.getMachineBit(), (Object)this.machineProperties.getMachineBit());
        String namespace = Namespaces.firstNotBlank(idDefinition.getNamespace(), this.cosIdProperties.getNamespace());
        int machineId = this.machineIdDistributor.distribute(namespace, machineBit, this.instanceId, this.machineProperties.getSafeGuardDuration()).getMachineId();
        Object snowflakeId = SnowflakeIdProperties.IdDefinition.TimestampUnit.SECOND.equals((Object)idDefinition.getTimestampUnit()) ? new SecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit, idDefinition.getSequenceBit(), machineId, idDefinition.getSequenceResetThreshold()) : new MillisecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit, idDefinition.getSequenceBit(), machineId, idDefinition.getSequenceResetThreshold());
        if (idDefinition.isClockSync()) {
            snowflakeId = new ClockSyncSnowflakeId((SnowflakeId)snowflakeId, clockBackwardsSynchronizer);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        ZoneId zoneId = ZoneId.of(this.snowflakeIdProperties.getZoneId());
        ToStringIdConverter idConverter = ToStringIdConverter.INSTANCE;
        switch (converterDefinition.getType()) {
            case TO_STRING: {
                IdConverterDefinition.ToString toString = converterDefinition.getToString();
                if (toString == null) break;
                idConverter = new ToStringIdConverter(toString.isPadStart(), toString.getCharSize());
                break;
            }
            case SNOWFLAKE_FRIENDLY: {
                idConverter = new SnowflakeFriendlyIdConverter(SnowflakeIdStateParser.of((SnowflakeId)snowflakeId, (ZoneId)zoneId));
                break;
            }
            case RADIX: {
                IdConverterDefinition.Radix radix = converterDefinition.getRadix();
                idConverter = Radix62IdConverter.of((boolean)radix.isPadStart(), (int)radix.getCharSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)converterDefinition.getType()));
            }
        }
        if (!Strings.isNullOrEmpty((String)converterDefinition.getPrefix())) {
            idConverter = new PrefixIdConverter(converterDefinition.getPrefix(), (IdConverter)idConverter);
        }
        if (!Strings.isNullOrEmpty((String)converterDefinition.getSuffix())) {
            idConverter = new SuffixIdConverter(converterDefinition.getSuffix(), (IdConverter)idConverter);
        }
        if (idDefinition.isFriendly()) {
            SnowflakeIdStateParser snowflakeIdStateParser = SnowflakeIdStateParser.of((SnowflakeId)snowflakeId, (ZoneId)zoneId);
            return new DefaultSnowflakeFriendlyId((SnowflakeId)snowflakeId, (IdConverter)idConverter, snowflakeIdStateParser);
        }
        return new StringSnowflakeId((SnowflakeId)snowflakeId, (IdConverter)idConverter);
    }

    private long getEpoch(SnowflakeIdProperties.IdDefinition idDefinition) {
        if (idDefinition.getEpoch() > 0L) {
            return idDefinition.getEpoch();
        }
        return this.snowflakeIdProperties.getEpoch();
    }
}

