/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.machine;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.MachineStateStorage;
import me.ahoo.cosid.mongo.MachineCollection;
import me.ahoo.cosid.mongo.MongoMachineCollection;
import me.ahoo.cosid.mongo.MongoMachineIdDistributor;
import me.ahoo.cosid.mongo.MongoMachineInitializer;
import me.ahoo.cosid.mongo.reactive.MongoReactiveMachineCollection;
import me.ahoo.cosid.mongo.reactive.MongoReactiveMachineInitializer;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.machine.ConditionalOnCosIdMachineEnabled;
import me.ahoo.cosid.spring.boot.starter.machine.MachineProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdMachineEnabled
@ConditionalOnClass(value={MongoMachineIdDistributor.class})
@ConditionalOnProperty(value={"cosid.machine.distributor.type"}, havingValue="mongo")
@AutoConfigureAfter(value={MongoAutoConfiguration.class, MongoReactiveAutoConfiguration.class})
public class CosIdMongoMachineIdDistributorAutoConfiguration {
    private final MachineProperties machineProperties;

    public CosIdMongoMachineIdDistributorAutoConfiguration(MachineProperties machineProperties) {
        this.machineProperties = machineProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoMachineIdDistributor mongoMachineIdDistributor(MachineCollection machineCollection, MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        return new MongoMachineIdDistributor(machineCollection, localMachineState, clockBackwardsSynchronizer);
    }

    @Configuration
    @ConditionalOnClass(value={com.mongodb.reactivestreams.client.MongoClient.class})
    class Reactive {
        Reactive() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MongoReactiveMachineInitializer mongoReactiveMachineInitializer(com.mongodb.reactivestreams.client.MongoClient mongoClient) {
            com.mongodb.reactivestreams.client.MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoMachineIdDistributorAutoConfiguration.this.machineProperties.getDistributor().getMongo().getDatabase());
            return new MongoReactiveMachineInitializer(mongoDatabase);
        }

        @Bean
        @ConditionalOnMissingBean
        public MongoReactiveMachineCollection mongoReactiveMachineCollection(com.mongodb.reactivestreams.client.MongoClient mongoClient) {
            com.mongodb.reactivestreams.client.MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoMachineIdDistributorAutoConfiguration.this.machineProperties.getDistributor().getMongo().getDatabase());
            return new MongoReactiveMachineCollection(mongoDatabase.getCollection("cosid_machine"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoClient.class})
    class Sync {
        Sync() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public MongoMachineInitializer mongoMachineInitializer(MongoClient mongoClient) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoMachineIdDistributorAutoConfiguration.this.machineProperties.getDistributor().getMongo().getDatabase());
            return new MongoMachineInitializer(mongoDatabase);
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public MongoMachineCollection mongoMachineCollection(MongoClient mongoClient) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoMachineIdDistributorAutoConfiguration.this.machineProperties.getDistributor().getMongo().getDatabase());
            return new MongoMachineCollection(mongoDatabase.getCollection("cosid_machine"));
        }
    }
}

