/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import jakarta.annotation.Nonnull;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="cosid.snowflake")
public class SnowflakeIdProperties {
    public static final String PREFIX = "cosid.snowflake";
    private boolean enabled = false;
    private String zoneId = ZoneId.systemDefault().getId();
    private long epoch = 1577203200000L;
    private ShardIdDefinition share = new ShardIdDefinition();
    private Map<String, IdDefinition> provider = new HashMap<String, IdDefinition>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public ShardIdDefinition getShare() {
        return this.share;
    }

    public void setShare(ShardIdDefinition share) {
        this.share = share;
    }

    @Nonnull
    public Map<String, IdDefinition> getProvider() {
        return this.provider;
    }

    public void setProvider(Map<String, IdDefinition> provider) {
        this.provider = provider;
    }

    public static class ShardIdDefinition
    extends IdDefinition {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class IdDefinition {
        private String namespace;
        private boolean clockSync = true;
        private TimestampUnit timestampUnit = TimestampUnit.MILLISECOND;
        private long epoch;
        private Integer machineBit;
        private int timestampBit = 41;
        private int sequenceBit = 12;
        private long sequenceResetThreshold = 2047L;
        @NestedConfigurationProperty
        private IdConverterDefinition converter = new IdConverterDefinition();

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean isClockSync() {
            return this.clockSync;
        }

        public void setClockSync(boolean clockSync) {
            this.clockSync = clockSync;
        }

        public TimestampUnit getTimestampUnit() {
            return this.timestampUnit;
        }

        public void setTimestampUnit(TimestampUnit timestampUnit) {
            this.timestampUnit = timestampUnit;
        }

        public long getEpoch() {
            return this.epoch;
        }

        public void setEpoch(long epoch) {
            this.epoch = epoch;
        }

        public Integer getMachineBit() {
            return this.machineBit;
        }

        public void setMachineBit(Integer machineBit) {
            this.machineBit = machineBit;
        }

        public int getTimestampBit() {
            return this.timestampBit;
        }

        public void setTimestampBit(int timestampBit) {
            this.timestampBit = timestampBit;
        }

        public int getSequenceBit() {
            return this.sequenceBit;
        }

        public void setSequenceBit(int sequenceBit) {
            this.sequenceBit = sequenceBit;
        }

        public long getSequenceResetThreshold() {
            return this.sequenceResetThreshold;
        }

        public void setSequenceResetThreshold(long sequenceResetThreshold) {
            this.sequenceResetThreshold = sequenceResetThreshold;
        }

        public IdConverterDefinition getConverter() {
            return this.converter;
        }

        public void setConverter(IdConverterDefinition converter) {
            this.converter = converter;
        }

        public static enum TimestampUnit {
            SECOND,
            MILLISECOND;

        }
    }
}

