/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.actuate;

import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.actuate.CosIdEndpoint;
import me.ahoo.cosid.spring.boot.starter.actuate.CosIdGeneratorEndpoint;
import me.ahoo.cosid.spring.boot.starter.actuate.CosIdStringGeneratorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnClass(value={Endpoint.class})
public class CosIdEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CosIdEndpoint cosIdEndpoint(IdGeneratorProvider idGeneratorProvider) {
        return new CosIdEndpoint(idGeneratorProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdGeneratorEndpoint cosIdGeneratorEndpoint(IdGeneratorProvider idGeneratorProvider) {
        return new CosIdGeneratorEndpoint(idGeneratorProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdStringGeneratorEndpoint cosIdStringGeneratorEndpoint(IdGeneratorProvider idGeneratorProvider) {
        return new CosIdStringGeneratorEndpoint(idGeneratorProvider);
    }
}

