/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.converter.GroupedPrefixIdConverter;
import me.ahoo.cosid.converter.PrefixIdConverter;
import me.ahoo.cosid.converter.Radix36IdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SuffixIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;

public abstract class IdConverterDecorator<T extends IdGenerator> {
    protected final T idGenerator;
    protected final IdConverterDefinition converterDefinition;

    protected IdConverterDecorator(T idGenerator, IdConverterDefinition converterDefinition) {
        this.idGenerator = idGenerator;
        this.converterDefinition = converterDefinition;
    }

    public T decorate() {
        ToStringIdConverter idConverter = ToStringIdConverter.INSTANCE;
        switch (this.converterDefinition.getType()) {
            case TO_STRING: {
                idConverter = this.newToString((IdConverter)idConverter);
                break;
            }
            case RADIX: {
                idConverter = this.newRadix();
                break;
            }
            case RADIX36: {
                idConverter = this.newRadix36();
                break;
            }
            case SNOWFLAKE_FRIENDLY: {
                idConverter = this.newSnowflakeFriendly();
                break;
            }
            case CUSTOM: {
                idConverter = this.newCustom();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.converterDefinition.getType());
            }
        }
        IdConverterDefinition.GroupPrefix groupPrefix = this.converterDefinition.getGroupPrefix();
        if (groupPrefix.isEnabled() && groupPrefix.isBeforePrefix()) {
            idConverter = new GroupedPrefixIdConverter(groupPrefix.getDelimiter(), (IdConverter)idConverter);
        }
        if (!Strings.isNullOrEmpty((String)this.converterDefinition.getPrefix())) {
            idConverter = new PrefixIdConverter(this.converterDefinition.getPrefix(), (IdConverter)idConverter);
        }
        if (groupPrefix.isEnabled() && !groupPrefix.isBeforePrefix()) {
            idConverter = new GroupedPrefixIdConverter(groupPrefix.getDelimiter(), (IdConverter)idConverter);
        }
        if (!Strings.isNullOrEmpty((String)this.converterDefinition.getSuffix())) {
            idConverter = new SuffixIdConverter(this.converterDefinition.getSuffix(), (IdConverter)idConverter);
        }
        return this.newIdGenerator((IdConverter)idConverter);
    }

    protected IdConverter newRadix() {
        IdConverterDefinition.Radix radix = this.converterDefinition.getRadix();
        return Radix62IdConverter.of((boolean)radix.isPadStart(), (int)radix.getCharSize());
    }

    protected IdConverter newRadix36() {
        IdConverterDefinition.Radix36 radix36 = this.converterDefinition.getRadix36();
        return Radix36IdConverter.of((boolean)radix36.isPadStart(), (int)radix36.getCharSize());
    }

    protected IdConverter newToString(IdConverter defaultIdConverter) {
        IdConverterDefinition.ToString toString = this.converterDefinition.getToString();
        if (toString != null) {
            return new ToStringIdConverter(toString.isPadStart(), toString.getCharSize());
        }
        return defaultIdConverter;
    }

    protected IdConverter newSnowflakeFriendly() {
        throw new UnsupportedOperationException("newSnowflakeFriendly");
    }

    protected IdConverter newCustom() {
        IdConverterDefinition.Custom custom = this.converterDefinition.getCustom();
        try {
            return custom.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract T newIdGenerator(IdConverter var1);
}

