/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.actuate;

import java.util.HashMap;
import java.util.Map;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.stat.Stat;
import me.ahoo.cosid.stat.Statistical;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="cosid")
public class CosIdEndpoint {
    private final IdGeneratorProvider idGeneratorProvider;

    public CosIdEndpoint(IdGeneratorProvider idGeneratorProvider) {
        this.idGeneratorProvider = idGeneratorProvider;
    }

    @ReadOperation
    public Map<String, Stat> stat() {
        HashMap<String, Stat> statMap = new HashMap<String, Stat>();
        for (Map.Entry entry : this.idGeneratorProvider.entries()) {
            Stat stat = Statistical.stat((IdGenerator)((IdGenerator)entry.getValue()));
            statMap.put((String)entry.getKey(), stat);
        }
        return statMap;
    }

    @ReadOperation
    public Stat getStat(@Selector String name) {
        IdGenerator idGenerator = this.idGeneratorProvider.getRequired(name);
        return Statistical.stat((IdGenerator)idGenerator);
    }

    @DeleteOperation
    public Stat remove(@Selector String name) {
        IdGenerator idGenerator = this.idGeneratorProvider.remove(name);
        return Statistical.stat((IdGenerator)idGenerator);
    }
}

