/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import com.google.common.base.MoreObjects;
import lombok.Generated;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.segment.DefaultSegmentId;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.SegmentChainId;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.segment.concurrent.PrefetchWorkerExecutorService;
import me.ahoo.cosid.segment.grouped.DateGroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupedIdSegmentDistributorFactory;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.Namespaces;
import me.ahoo.cosid.spring.boot.starter.segment.CustomizeSegmentIdProperties;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdConverterDecorator;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;

public class SegmentIdBeanRegistrar
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentIdBeanRegistrar.class);
    private final CosIdProperties cosIdProperties;
    private final SegmentIdProperties segmentIdProperties;
    private final IdSegmentDistributorFactory distributorFactory;
    private final IdGeneratorProvider idGeneratorProvider;
    private final PrefetchWorkerExecutorService prefetchWorkerExecutorService;
    private final ConfigurableApplicationContext applicationContext;
    @Nullable
    private final CustomizeSegmentIdProperties customizeSegmentIdProperties;

    public SegmentIdBeanRegistrar(CosIdProperties cosIdProperties, SegmentIdProperties segmentIdProperties, IdSegmentDistributorFactory distributorFactory, IdGeneratorProvider idGeneratorProvider, PrefetchWorkerExecutorService prefetchWorkerExecutorService, ConfigurableApplicationContext applicationContext, @Nullable CustomizeSegmentIdProperties customizeSegmentIdProperties) {
        this.cosIdProperties = cosIdProperties;
        this.segmentIdProperties = segmentIdProperties;
        this.distributorFactory = distributorFactory;
        this.idGeneratorProvider = idGeneratorProvider;
        this.prefetchWorkerExecutorService = prefetchWorkerExecutorService;
        this.applicationContext = applicationContext;
        this.customizeSegmentIdProperties = customizeSegmentIdProperties;
    }

    public void afterPropertiesSet() {
        this.register();
    }

    public void register() {
        SegmentIdProperties.ShardIdDefinition shareIdDefinition;
        if (this.customizeSegmentIdProperties != null) {
            this.customizeSegmentIdProperties.customize(this.segmentIdProperties);
        }
        if ((shareIdDefinition = this.segmentIdProperties.getShare()).isEnabled()) {
            this.registerIdDefinition("__share__", shareIdDefinition);
        }
        this.segmentIdProperties.getProvider().forEach(this::registerIdDefinition);
    }

    private void registerIdDefinition(String name, SegmentIdProperties.IdDefinition idDefinition) {
        IdSegmentDistributorDefinition distributorDefinition = this.asDistributorDefinition(name, idDefinition);
        IdSegmentDistributor idSegmentDistributor = idDefinition.getGroup().getBy() == SegmentIdProperties.IdDefinition.GroupBy.YEAR ? new GroupedIdSegmentDistributorFactory((GroupBySupplier)DateGroupBySupplier.YEAR, this.distributorFactory).create(distributorDefinition) : this.distributorFactory.create(distributorDefinition);
        SegmentId idGenerator = SegmentIdBeanRegistrar.createSegment(this.segmentIdProperties, idDefinition, idSegmentDistributor, this.prefetchWorkerExecutorService);
        this.registerSegmentId(name, idGenerator);
    }

    private void registerSegmentId(String name, SegmentId segmentId) {
        if (!this.idGeneratorProvider.get(name).isPresent()) {
            this.idGeneratorProvider.set(name, (IdGenerator)segmentId);
        }
        String beanName = name + "SegmentId";
        this.applicationContext.getBeanFactory().registerSingleton(beanName, (Object)segmentId);
    }

    private IdSegmentDistributorDefinition asDistributorDefinition(String name, SegmentIdProperties.IdDefinition idDefinition) {
        String namespace = Namespaces.firstNotBlank(idDefinition.getNamespace(), this.cosIdProperties.getNamespace());
        return new IdSegmentDistributorDefinition(namespace, name, idDefinition.getOffset(), idDefinition.getStep());
    }

    private static SegmentId createSegment(SegmentIdProperties segmentIdProperties, SegmentIdProperties.IdDefinition idDefinition, IdSegmentDistributor idSegmentDistributor, PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        DefaultSegmentId segmentId;
        long ttl = (Long)MoreObjects.firstNonNull((Object)idDefinition.getTtl(), (Object)segmentIdProperties.getTtl());
        SegmentIdProperties.Mode mode = (SegmentIdProperties.Mode)((Object)MoreObjects.firstNonNull((Object)((Object)idDefinition.getMode()), (Object)((Object)segmentIdProperties.getMode())));
        if (SegmentIdProperties.Mode.SEGMENT.equals((Object)mode)) {
            segmentId = new DefaultSegmentId(ttl, idSegmentDistributor);
        } else {
            SegmentIdProperties.Chain chain = (SegmentIdProperties.Chain)MoreObjects.firstNonNull((Object)idDefinition.getChain(), (Object)segmentIdProperties.getChain());
            segmentId = new SegmentChainId(ttl, chain.getSafeDistance(), idSegmentDistributor, prefetchWorkerExecutorService);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        return (SegmentId)new SegmentIdConverterDecorator((SegmentId)segmentId, converterDefinition).decorate();
    }
}

