/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import me.ahoo.cosid.mongo.IdSegmentInitializer;
import me.ahoo.cosid.mongo.MongoIdSegmentDistributorFactory;
import me.ahoo.cosid.mongo.MongoIdSegmentInitializer;
import me.ahoo.cosid.mongo.reactive.MongoReactiveIdSegmentDistributorFactory;
import me.ahoo.cosid.mongo.reactive.MongoReactiveIdSegmentInitializer;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.ConditionalOnCosIdSegmentEnabled;
import me.ahoo.cosid.spring.boot.starter.segment.SegmentIdProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdSegmentEnabled
@EnableConfigurationProperties(value={SegmentIdProperties.class})
@ConditionalOnClass(value={MongoIdSegmentDistributorFactory.class})
@ConditionalOnProperty(value={"cosid.segment.distributor.type"}, havingValue="mongo")
@AutoConfigureAfter(value={MongoAutoConfiguration.class, MongoReactiveAutoConfiguration.class})
public class CosIdMongoSegmentAutoConfiguration {
    private final SegmentIdProperties segmentIdProperties;

    public CosIdMongoSegmentAutoConfiguration(SegmentIdProperties segmentIdProperties) {
        this.segmentIdProperties = segmentIdProperties;
    }

    @Configuration
    @ConditionalOnClass(value={com.mongodb.reactivestreams.client.MongoClient.class})
    class Reactive {
        Reactive() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MongoReactiveIdSegmentInitializer mongoReactiveIdSegmentInitializer(com.mongodb.reactivestreams.client.MongoClient mongoClient) {
            com.mongodb.reactivestreams.client.MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoSegmentAutoConfiguration.this.segmentIdProperties.getDistributor().getMongo().getDatabase());
            return new MongoReactiveIdSegmentInitializer(mongoDatabase);
        }

        @Bean
        @ConditionalOnMissingBean
        public MongoReactiveIdSegmentDistributorFactory mongoReactiveIdSegmentDistributorFactory(com.mongodb.reactivestreams.client.MongoClient mongoClient, IdSegmentInitializer idSegmentInitializer) {
            idSegmentInitializer.ensureCosIdCollection();
            com.mongodb.reactivestreams.client.MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoSegmentAutoConfiguration.this.segmentIdProperties.getDistributor().getMongo().getDatabase());
            return new MongoReactiveIdSegmentDistributorFactory(mongoDatabase, true);
        }
    }

    @Order(value=0)
    @Configuration
    @ConditionalOnClass(value={MongoClient.class})
    class Sync {
        Sync() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public MongoIdSegmentInitializer mongoIdSegmentInitializer(MongoClient mongoClient) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoSegmentAutoConfiguration.this.segmentIdProperties.getDistributor().getMongo().getDatabase());
            return new MongoIdSegmentInitializer(mongoDatabase);
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public MongoIdSegmentDistributorFactory mongoIdSegmentDistributorFactory(MongoClient mongoClient, IdSegmentInitializer idSegmentInitializer) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(CosIdMongoSegmentAutoConfiguration.this.segmentIdProperties.getDistributor().getMongo().getDatabase());
            idSegmentInitializer.ensureCosIdCollection();
            return new MongoIdSegmentDistributorFactory(mongoDatabase, true);
        }
    }
}

