/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.segment;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ahoo.cosid.segment.concurrent.PrefetchWorkerExecutorService;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="cosid.segment")
public class SegmentIdProperties {
    public static final String PREFIX = "cosid.segment";
    private boolean enabled = false;
    private Mode mode = Mode.CHAIN;
    private long ttl = Long.MAX_VALUE;
    private Distributor distributor;
    private Chain chain;
    private ShardIdDefinition share = new ShardIdDefinition();
    private Map<String, IdDefinition> provider;

    public SegmentIdProperties() {
        this.distributor = new Distributor();
        this.chain = new Chain();
        this.provider = new HashMap<String, IdDefinition>();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public Distributor getDistributor() {
        return this.distributor;
    }

    public void setDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    public Chain getChain() {
        return this.chain;
    }

    public void setChain(Chain chain) {
        this.chain = chain;
    }

    public ShardIdDefinition getShare() {
        return this.share;
    }

    public void setShare(ShardIdDefinition share) {
        this.share = share;
    }

    @Nonnull
    public Map<String, IdDefinition> getProvider() {
        return this.provider;
    }

    public void setProvider(Map<String, IdDefinition> provider) {
        this.provider = provider;
    }

    public static enum Mode {
        SEGMENT,
        CHAIN;

    }

    public static class ShardIdDefinition
    extends IdDefinition {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Distributor {
        public static final String TYPE = "cosid.segment.distributor.type";
        private Type type = Type.REDIS;
        private Redis redis = new Redis();
        private Jdbc jdbc = new Jdbc();
        private Mongo mongo = new Mongo();

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Redis getRedis() {
            return this.redis;
        }

        public void setRedis(Redis redis) {
            this.redis = redis;
        }

        public Jdbc getJdbc() {
            return this.jdbc;
        }

        public void setJdbc(Jdbc jdbc) {
            this.jdbc = jdbc;
        }

        public Mongo getMongo() {
            return this.mongo;
        }

        public void setMongo(Mongo mongo) {
            this.mongo = mongo;
        }

        public static enum Type {
            REDIS,
            JDBC,
            MONGO,
            ZOOKEEPER,
            PROXY;

        }

        public static class Redis {
            private Duration timeout = Duration.ofSeconds(1L);

            public Duration getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Duration timeout) {
                this.timeout = timeout;
            }
        }

        public static class Jdbc {
            private String incrementMaxIdSql = "update cosid set last_max_id=(last_max_id + ?),last_fetch_time=unix_timestamp() where name = ?;";
            private String fetchMaxIdSql = "select last_max_id from cosid where name = ?;";
            private boolean enableAutoInitCosidTable = false;
            private String initCosidTableSql = "create table if not exists cosid\n(\n    name            varchar(100) not null comment '{namespace}.{name}',\n    last_max_id     bigint unsigned not null default 0,\n    last_fetch_time bigint unsigned not null default 0,\n    constraint cosid_pk\n        primary key (name)\n) engine = InnoDB;";
            private boolean enableAutoInitIdSegment = true;
            private String initIdSegmentSql = "insert into cosid (name, last_max_id,last_fetch_time) value (?, ?,unix_timestamp());";

            public String getIncrementMaxIdSql() {
                return this.incrementMaxIdSql;
            }

            public void setIncrementMaxIdSql(String incrementMaxIdSql) {
                this.incrementMaxIdSql = incrementMaxIdSql;
            }

            public String getFetchMaxIdSql() {
                return this.fetchMaxIdSql;
            }

            public void setFetchMaxIdSql(String fetchMaxIdSql) {
                this.fetchMaxIdSql = fetchMaxIdSql;
            }

            public boolean isEnableAutoInitCosidTable() {
                return this.enableAutoInitCosidTable;
            }

            public void setEnableAutoInitCosidTable(boolean enableAutoInitCosidTable) {
                this.enableAutoInitCosidTable = enableAutoInitCosidTable;
            }

            public String getInitCosidTableSql() {
                return this.initCosidTableSql;
            }

            public void setInitCosidTableSql(String initCosidTableSql) {
                this.initCosidTableSql = initCosidTableSql;
            }

            public boolean isEnableAutoInitIdSegment() {
                return this.enableAutoInitIdSegment;
            }

            public void setEnableAutoInitIdSegment(boolean enableAutoInitIdSegment) {
                this.enableAutoInitIdSegment = enableAutoInitIdSegment;
            }

            public String getInitIdSegmentSql() {
                return this.initIdSegmentSql;
            }

            public void setInitIdSegmentSql(String initIdSegmentSql) {
                this.initIdSegmentSql = initIdSegmentSql;
            }
        }

        public static class Mongo {
            private String database = "cosid_db";

            public String getDatabase() {
                return this.database;
            }

            public void setDatabase(String database) {
                this.database = database;
            }
        }
    }

    public static class Chain {
        private int safeDistance = 2;
        private PrefetchWorker prefetchWorker = new PrefetchWorker();

        public int getSafeDistance() {
            return this.safeDistance;
        }

        public void setSafeDistance(int safeDistance) {
            this.safeDistance = safeDistance;
        }

        public PrefetchWorker getPrefetchWorker() {
            return this.prefetchWorker;
        }

        public void setPrefetchWorker(PrefetchWorker prefetchWorker) {
            this.prefetchWorker = prefetchWorker;
        }

        public static class PrefetchWorker {
            private Duration prefetchPeriod = PrefetchWorkerExecutorService.DEFAULT_PREFETCH_PERIOD;
            private int corePoolSize = Runtime.getRuntime().availableProcessors();
            private boolean shutdownHook = true;

            public Duration getPrefetchPeriod() {
                return this.prefetchPeriod;
            }

            public void setPrefetchPeriod(Duration prefetchPeriod) {
                this.prefetchPeriod = prefetchPeriod;
            }

            public int getCorePoolSize() {
                return this.corePoolSize;
            }

            public void setCorePoolSize(int corePoolSize) {
                this.corePoolSize = corePoolSize;
            }

            public boolean isShutdownHook() {
                return this.shutdownHook;
            }

            public void setShutdownHook(boolean shutdownHook) {
                this.shutdownHook = shutdownHook;
            }
        }
    }

    public static class IdDefinition {
        private String namespace;
        private Mode mode;
        private long offset = 0L;
        private long step = 10L;
        private Long ttl;
        private Chain chain;
        @NestedConfigurationProperty
        private IdConverterDefinition converter = new IdConverterDefinition();
        private Group group = new Group();

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getStep() {
            return this.step;
        }

        public void setStep(long step) {
            this.step = step;
        }

        public Long getTtl() {
            return this.ttl;
        }

        public void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public Chain getChain() {
            return this.chain;
        }

        public void setChain(Chain chain) {
            this.chain = chain;
        }

        public IdConverterDefinition getConverter() {
            return this.converter;
        }

        public void setConverter(IdConverterDefinition converter) {
            this.converter = converter;
        }

        public Group getGroup() {
            return this.group;
        }

        public void setGroup(Group group) {
            this.group = group;
        }

        public static class Group {
            private GroupBy by = GroupBy.NEVER;
            private String pattern;

            public GroupBy getBy() {
                return this.by;
            }

            public Group setBy(GroupBy by) {
                this.by = by;
                return this;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }
        }

        public static enum GroupBy {
            YEAR,
            YEAR_MONTH,
            YEAR_MONTH_DAY,
            NEVER;

        }
    }
}

