/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import java.time.ZoneId;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.converter.SnowflakeFriendlyIdConverter;
import me.ahoo.cosid.snowflake.DefaultSnowflakeFriendlyId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.StringSnowflakeId;
import me.ahoo.cosid.spring.boot.starter.IdConverterDecorator;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;

public class SnowflakeIdConverterDecorator
extends IdConverterDecorator<SnowflakeId> {
    private final ZoneId zoneId;
    private final boolean isFriendly;

    protected SnowflakeIdConverterDecorator(SnowflakeId idGenerator, IdConverterDefinition converterDefinition, ZoneId zoneId, boolean isFriendly) {
        super(idGenerator, converterDefinition);
        this.zoneId = zoneId;
        this.isFriendly = isFriendly;
    }

    @Override
    protected IdConverter newSnowflakeFriendly() {
        return new SnowflakeFriendlyIdConverter(SnowflakeIdStateParser.of((SnowflakeId)((SnowflakeId)this.idGenerator), (ZoneId)this.zoneId));
    }

    @Override
    protected SnowflakeId newIdGenerator(IdConverter idConverter) {
        if (this.isFriendly) {
            SnowflakeIdStateParser snowflakeIdStateParser = SnowflakeIdStateParser.of((SnowflakeId)((SnowflakeId)this.idGenerator), (ZoneId)this.zoneId);
            return new DefaultSnowflakeFriendlyId((SnowflakeId)this.idGenerator, idConverter, snowflakeIdStateParser);
        }
        return new StringSnowflakeId((SnowflakeId)this.idGenerator, idConverter);
    }
}

