/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import lombok.Generated;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.spring.redis.SpringRedisMachineIdDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SpringRedisIdSegmentDistributor
implements IdSegmentDistributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringRedisIdSegmentDistributor.class);
    private final String namespace;
    private final String name;
    private final String adderKey;
    private final long offset;
    private final long step;
    private final StringRedisTemplate redisTemplate;
    private volatile long lastMaxId;

    public SpringRedisIdSegmentDistributor(String namespace, String name, StringRedisTemplate redisTemplate) {
        this(namespace, name, 0L, 10L, redisTemplate);
    }

    public SpringRedisIdSegmentDistributor(String namespace, String name, long offset, long step, StringRedisTemplate redisTemplate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name can not be empty!");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset:[%s] must be greater than or equal to 0!", (long)offset);
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (String)"step:[%s] must be greater than 0!", (long)step);
        this.namespace = namespace;
        this.name = name;
        this.offset = offset;
        this.step = step;
        this.redisTemplate = redisTemplate;
        this.adderKey = "cosid:" + SpringRedisMachineIdDistributor.hashTag(this.getNamespacedName()) + ".adder";
    }

    void ensureOffset() {
        if (log.isDebugEnabled()) {
            log.debug("Ensure Offset [{}] offset:[{}].", (Object)this.adderKey, (Object)this.offset);
        }
        Boolean notExists = this.redisTemplate.opsForValue().setIfAbsent((Object)this.adderKey, (Object)String.valueOf(this.offset));
        if (log.isDebugEnabled()) {
            log.debug("Ensure Offset [{}] offset:[{}] - notExists:[{}].", new Object[]{this.adderKey, this.offset, notExists});
        }
    }

    public String getAdderKey() {
        return this.adderKey;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getStep() {
        return this.step;
    }

    public long nextMaxId(long step) {
        IdSegmentDistributor.ensureStep((long)step);
        if (log.isDebugEnabled()) {
            log.debug("Next MaxId [{}] step:[{}].", (Object)this.adderKey, (Object)step);
        }
        long nextMinMaxId = this.lastMaxId + step;
        Long nextMaxId = this.redisTemplate.opsForValue().increment((Object)this.adderKey, step);
        assert (nextMaxId != null);
        Preconditions.checkNotNull((Object)nextMaxId, (Object)"nextMaxId can not be null!");
        if (log.isDebugEnabled()) {
            log.debug("Next MaxId [{}] step:[{}] - nextMaxId:[{}].", new Object[]{this.adderKey, step, nextMaxId});
        }
        Preconditions.checkState((nextMaxId >= nextMinMaxId ? 1 : 0) != 0, (String)"nextMaxId:[%s] must be greater than nextMinMaxId:[%s]!", (Object)nextMaxId, (long)nextMinMaxId);
        this.lastMaxId = nextMaxId;
        return nextMaxId;
    }
}

