/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.test.TestSpec;

public class ConcurrentGenerateSpec
implements TestSpec {
    private final IdGenerator[] idGenerators;
    private final int concurrentThreads;
    private final long idSize;
    private final int singleGenerates;

    public ConcurrentGenerateSpec(IdGenerator ... idGenerators) {
        this(10, 800000L, idGenerators);
    }

    public ConcurrentGenerateSpec(int concurrentThreads, long idSize, IdGenerator ... idGenerators) {
        Preconditions.checkState((idGenerators.length > 0 ? 1 : 0) != 0, (Object)"idGenerators can not be empty.");
        this.idGenerators = idGenerators;
        this.concurrentThreads = concurrentThreads;
        this.idSize = idSize;
        this.singleGenerates = (int)(idSize / (long)concurrentThreads);
    }

    public int getConcurrentThreads() {
        return this.concurrentThreads;
    }

    public long getIdSize() {
        return this.idSize;
    }

    private IdGenerator getIdGenerator(int threadIdx) {
        return this.idGenerators[threadIdx % this.idGenerators.length];
    }

    protected void assertSingleEach(long previousId, long id) {
        Preconditions.checkState((id > previousId ? 1 : 0) != 0, (String)"id:[%s] must greater then previousId:[%s]", (long)id, (long)previousId);
    }

    protected void assertGlobalFirst(long id) {
        Preconditions.checkState((1L == id ? 1 : 0) != 0, (String)"id:[%s] must equals 1.", (long)id);
    }

    protected void assertGlobalEach(long previousId, long id) {
        Preconditions.checkState((id == previousId + 1L ? 1 : 0) != 0, (String)"id:[%s] must equals previousId:[%s]+1.", (long)id, (long)previousId);
    }

    protected void assertGlobalLast(long lastId) {
        Preconditions.checkState((this.getIdSize() == lastId ? 1 : 0) != 0, (String)"lastId:[%s] must equals idSize:[%s]", (long)lastId, (long)this.getIdSize());
    }

    @Override
    public void verify() {
        CompletableFuture[] completableFutures = new CompletableFuture[this.concurrentThreads];
        for (int i = 0; i < completableFutures.length; ++i) {
            IdGenerator idGenerator = this.getIdGenerator(i);
            completableFutures[i] = CompletableFuture.supplyAsync(() -> {
                long[] ids = new long[this.singleGenerates];
                long previousId = 0L;
                for (int j = 0; j < ids.length; ++j) {
                    long nextId;
                    ids[j] = nextId = idGenerator.generate();
                    this.assertSingleEach(previousId, nextId);
                    previousId = nextId;
                }
                return ids;
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(completableFutures).thenAccept(nil -> {
            long[] totalIds = new long[(int)this.idSize];
            int totalIdx = 0;
            for (CompletableFuture completableFuture : completableFutures) {
                long[] ids;
                for (long id : ids = (long[])completableFuture.join()) {
                    totalIds[totalIdx++] = id;
                }
            }
            Arrays.sort(totalIds);
            long previousId = -1L;
            for (long id : totalIds) {
                if (-1L == previousId) {
                    this.assertGlobalFirst(id);
                    previousId = id;
                    continue;
                }
                this.assertGlobalEach(previousId, id);
                previousId = id;
            }
            this.assertGlobalLast(previousId);
        })).join();
    }
}

