/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.segment.distributor;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.segment.DefaultSegmentId;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentChain;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.SegmentChainId;
import me.ahoo.cosid.segment.grouped.GroupedKey;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.ConcurrentGenerateSpec;
import me.ahoo.cosid.test.MockIdGenerator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public abstract class IdSegmentDistributorSpec {
    static final long TEST_OFFSET = 0L;
    static final long TEST_STEP = 100L;

    protected abstract IdSegmentDistributorFactory getFactory();

    protected IdSegmentDistributorFactory factory() {
        return this.getFactory();
    }

    @Test
    public void getGroup() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        String name = "getGroup";
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, name, 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        MatcherAssert.assertThat((Object)distributor.group(), (Matcher)Matchers.equalTo((Object)GroupedKey.NEVER));
    }

    @Test
    public void getNamespace() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        String name = "getNamespace";
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, name, 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        MatcherAssert.assertThat((Object)distributor.getNamespace(), (Matcher)Matchers.equalTo((Object)namespace));
    }

    @Test
    public void getName() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        String name = "getName";
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, name, 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        MatcherAssert.assertThat((Object)distributor.getName(), (Matcher)Matchers.equalTo((Object)name));
    }

    @Test
    public void getNamespacedName() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        String name = "getNamespacedName";
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, name, 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        String expected = IdSegmentDistributor.getNamespacedName((String)namespace, (String)name);
        MatcherAssert.assertThat((Object)distributor.getNamespacedName(), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void getStep() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "getStep", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        MatcherAssert.assertThat((Object)distributor.getStep(), (Matcher)Matchers.equalTo((Object)100L));
    }

    @Test
    public void getStepWithSegments() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        int segments = ThreadLocalRandom.current().nextInt();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "getStepWithSegments", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expected = Math.multiplyExact(100L, segments);
        long actual = distributor.getStep(segments);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void nextMaxId() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextMaxId", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expected = 100L;
        long actual = distributor.nextMaxId();
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
        long actual2 = distributor.nextMaxId();
        MatcherAssert.assertThat((Object)actual2, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(actual)));
    }

    @Test
    public void nextMaxIdWithStep() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        long step = 50L;
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextMaxIdWithStep", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expected = 0L + step;
        long actual = distributor.nextMaxId(step);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
    }

    protected abstract <T extends IdSegmentDistributor> void setMaxIdBack(T var1, long var2);

    @Test
    public void nextMaxIdWhenBack() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextMaxIdWhenBack", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expected = 100L;
        long actual = distributor.nextMaxId();
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
        this.setMaxIdBack(distributor, actual);
        Assert.assertThrows(IllegalStateException.class, () -> ((IdSegmentDistributor)distributor).nextMaxId());
    }

    @Test
    public void nextIdSegment() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegment", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 100L;
        IdSegment actual = distributor.nextIdSegment();
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test
    public void nextIdSegmentWithTtl() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        long ttl = 10L;
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegmentWithTtl", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 100L;
        IdSegment actual = distributor.nextIdSegment(ttl);
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)ttl));
    }

    @Test
    public void nextIdSegmentWithSegmentsAndTtl() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        int segments = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        long ttl = 10L;
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegmentWithSegmentsAndTtl", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 0L + Math.multiplyExact(100L, segments);
        long expectedStep = Math.multiplyExact(100L, segments);
        IdSegment actual = distributor.nextIdSegment(segments, ttl);
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)expectedStep));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)ttl));
    }

    @Test
    public void nextIdSegmentChain() {
        IdSegmentChain root = IdSegmentChain.newRoot((boolean)false);
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegmentChain", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 0L + Math.multiplyExact(100L, 1);
        IdSegmentChain actual = distributor.nextIdSegmentChain(root);
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test
    public void nextMaxIdConcurrent() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        int concurrency = 20;
        CompletableFuture[] results = new CompletableFuture[concurrency];
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextMaxIdConcurrent", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        for (int i = 0; i < concurrency; ++i) {
            results[i] = CompletableFuture.supplyAsync(() -> distributor.nextMaxId(1L));
        }
        CompletableFuture.allOf(results).join();
        Long[] machineIds = (Long[])Arrays.stream(results).map(CompletableFuture::join).sorted().toArray(Long[]::new);
        for (int i = 0; i < machineIds.length; ++i) {
            MatcherAssert.assertThat((Object)machineIds[i], (Matcher)Matchers.equalTo((Object)(i + 1)));
        }
    }

    @Test
    public void generateConcurrent() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "generateConcurrent", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        DefaultSegmentId segmentId = new DefaultSegmentId(distributor);
        new ConcurrentGenerateSpec(new IdGenerator[]{segmentId}).verify();
    }

    @Test
    public void generateConcurrentOfChain() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "generateConcurrentOfChain", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        SegmentChainId segmentId = new SegmentChainId(distributor);
        new ConcurrentGenerateSpec(new IdGenerator[]{segmentId}).verify();
    }

    @Test
    public void generateMultiInstanceConcurrent() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "generateMultiInstanceConcurrent", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        DefaultSegmentId segmentId = new DefaultSegmentId(distributor);
        IdSegmentDistributor distributor2 = this.factory().create(definition);
        DefaultSegmentId segmentId2 = new DefaultSegmentId(distributor2);
        new ConcurrentGenerateSpec(new IdGenerator[]{segmentId, segmentId2}).verify();
    }
}

