/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class Guard
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;
    private final int machineBit;

    public Guard(Supplier<MachineIdDistributor> implFactory, int machineBit) {
        this.implFactory = implFactory;
        this.machineBit = machineBit;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("Guard").generateAsString();
        int port = ThreadLocalRandom.current().nextInt(0, 65535);
        InstanceId instanceId = MachineIdDistributorSpec.mockInstance(port, false);
        int machineId = distributor.distribute(namespace, this.machineBit, instanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION).getMachineId();
        MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)0));
        distributor.guard(namespace, instanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION);
    }
}

