/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.segment.distributor;

import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentChain;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import me.ahoo.cosid.segment.grouped.DateGroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupBySupplier;
import me.ahoo.cosid.segment.grouped.GroupedIdSegmentDistributorFactory;
import me.ahoo.cosid.segment.grouped.GroupedKey;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.segment.distributor.IdSegmentDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public abstract class GroupedIdSegmentDistributorSpec
extends IdSegmentDistributorSpec {
    protected GroupBySupplier groupedSupplier() {
        return DateGroupBySupplier.YEAR;
    }

    @Override
    public void nextMaxIdWhenBack() {
    }

    @Override
    protected <T extends IdSegmentDistributor> void setMaxIdBack(T distributor, long maxId) {
    }

    @Override
    protected IdSegmentDistributorFactory factory() {
        return new GroupedIdSegmentDistributorFactory(this.groupedSupplier(), this.getFactory());
    }

    @Override
    @Test
    public void getGroup() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        String name = "getGroup";
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, name, 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        MatcherAssert.assertThat((Object)distributor.group(), (Matcher)Matchers.equalTo((Object)((GroupedKey)this.groupedSupplier().get())));
    }

    @Override
    @Test
    public void nextIdSegment() {
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegment", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 100L;
        IdSegment actual = distributor.nextIdSegment();
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)((GroupedKey)this.groupedSupplier().get()).ttl()));
    }

    @Override
    @Test
    public void nextIdSegmentChain() {
        IdSegmentChain root = IdSegmentChain.newRoot((boolean)false);
        String namespace = MockIdGenerator.INSTANCE.generateAsString();
        IdSegmentDistributorDefinition definition = new IdSegmentDistributorDefinition(namespace, "nextIdSegmentChain", 0L, 100L);
        IdSegmentDistributor distributor = this.factory().create(definition);
        long expectedMaxId = 0L + Math.multiplyExact(100L, 1);
        IdSegmentChain actual = distributor.nextIdSegmentChain(root);
        MatcherAssert.assertThat((Object)actual.getMaxId(), (Matcher)Matchers.equalTo((Object)expectedMaxId));
        MatcherAssert.assertThat((Object)actual.getStep(), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)actual.getSequence(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)actual.getTtl(), (Matcher)Matchers.equalTo((Object)((GroupedKey)this.groupedSupplier().get()).ttl()));
    }
}

