/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.test.TestSpec;

public class ConcurrentGenerateStingSpec
implements TestSpec {
    private final IdGenerator[] idGenerators;
    private final int concurrentThreads;
    private final long idSize;
    private final int singleGenerates;

    public ConcurrentGenerateStingSpec(IdGenerator ... idGenerators) {
        this(10, 800000L, idGenerators);
    }

    public ConcurrentGenerateStingSpec(int concurrentThreads, long idSize, IdGenerator ... idGenerators) {
        Preconditions.checkState((idGenerators.length > 0 ? 1 : 0) != 0, (Object)"idGenerators can not be empty.");
        this.idGenerators = idGenerators;
        this.concurrentThreads = concurrentThreads;
        this.idSize = idSize;
        this.singleGenerates = (int)(idSize / (long)concurrentThreads);
    }

    public int getConcurrentThreads() {
        return this.concurrentThreads;
    }

    public long getIdSize() {
        return this.idSize;
    }

    private IdGenerator getIdGenerator(int threadIdx) {
        return this.idGenerators[threadIdx % this.idGenerators.length];
    }

    protected void assertSingleEach(String previousId, String id) {
        Preconditions.checkState((id.compareTo(previousId) > 0 ? 1 : 0) != 0, (String)"id:[%s] must greater then previousId:[%s]", (Object)id, (Object)previousId);
    }

    protected void assertGlobalEach(String previousId, String id) {
        Preconditions.checkState((id.compareTo(previousId) > 0 ? 1 : 0) != 0, (String)"id:[%s] must equals previousId:[%s]+1.", (Object)id, (Object)previousId);
    }

    @Override
    public void verify() {
        CompletableFuture[] completableFutures = new CompletableFuture[this.concurrentThreads];
        for (int i = 0; i < completableFutures.length; ++i) {
            IdGenerator idGenerator = this.getIdGenerator(i);
            completableFutures[i] = CompletableFuture.supplyAsync(() -> {
                String[] ids = new String[this.singleGenerates];
                String previousId = "0";
                for (int j = 0; j < ids.length; ++j) {
                    String nextId;
                    ids[j] = nextId = idGenerator.generateAsString();
                    this.assertSingleEach(previousId, nextId);
                    previousId = nextId;
                }
                return ids;
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(completableFutures).thenAccept(nil -> {
            Object[] totalIds = new String[(int)this.idSize];
            int totalIdx = 0;
            for (CompletableFuture completableFuture : completableFutures) {
                String[] ids;
                for (String id : ids = (String[])completableFuture.join()) {
                    totalIds[totalIdx++] = id;
                }
            }
            Arrays.sort(totalIds);
            Object previousId = "-1";
            for (Object id : totalIds) {
                if ("-1".equals(previousId)) {
                    previousId = id;
                    continue;
                }
                this.assertGlobalEach((String)previousId, (String)id);
                previousId = id;
            }
        })).join();
    }
}

