/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongSupplier;
import lombok.Generated;
import me.ahoo.cosid.test.TestSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSpec
implements Runnable,
TestSpec {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModSpec.class);
    public static final Runnable DEFAULT_WAIT = () -> {
        int wait = ThreadLocalRandom.current().nextInt(0, 1000);
        LockSupport.parkNanos(wait);
    };
    private final int iterations;
    private final int divisor;
    private final double allowablePopStd;
    private final LongSupplier idGenerator;
    private final int expectedAvgHits;
    private final Runnable wait;
    private final int[] hits;
    private double popVariance;
    private double popStd;
    private double popStdError;

    public ModSpec(int iterations, int divisor, double allowablePopStd, LongSupplier idGenerator, Runnable wait) {
        this.iterations = iterations;
        this.divisor = divisor;
        this.allowablePopStd = allowablePopStd;
        this.idGenerator = idGenerator;
        this.wait = wait;
        this.expectedAvgHits = iterations / divisor;
        this.hits = new int[divisor];
    }

    @Override
    public void run() {
        if (this.hits[0] > 0) {
            return;
        }
        for (int i = 0; i < this.iterations; ++i) {
            int mod;
            long id = this.idGenerator.getAsLong();
            int n = mod = (int)(id % (long)this.divisor);
            this.hits[n] = this.hits[n] + 1;
            this.wait.run();
        }
        this.popVariance = Arrays.stream(this.hits).map(hit -> hit - this.expectedAvgHits).mapToDouble(diff -> Math.pow(diff, 2.0)).sum() / (double)this.hits.length;
        this.popStd = Math.sqrt(this.popVariance);
        this.popStdError = this.popStd / Math.sqrt(this.hits.length);
        if (log.isInfoEnabled()) {
            log.info("Report - iterations:{},divisor:{},allowablePopStd:{},expectedAvgHits:{},popStd:{},popStdError:{} - hits:{}", new Object[]{this.iterations, this.divisor, this.allowablePopStd, this.expectedAvgHits, this.popStd, this.popStdError, this.hits});
        }
    }

    @Override
    public void verify() {
        this.run();
        if (this.popStd > this.allowablePopStd) {
            throw new AssertionError((Object)("popStd:" + this.popStd + ",allowablePopStd:" + this.allowablePopStd));
        }
    }
}

