/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.jdbc;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.AbstractMutexContendService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.jdbc.MutexOwnerEntity;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.util.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/ahoo/simba/jdbc/JdbcMutexContendService;", "Lme/ahoo/simba/core/AbstractMutexContendService;", "mutexContender", "Lme/ahoo/simba/core/MutexContender;", "handleExecutor", "Ljava/util/concurrent/Executor;", "mutexOwnerRepository", "Lme/ahoo/simba/jdbc/MutexOwnerRepository;", "initialDelay", "Ljava/time/Duration;", "ttl", "transition", "<init>", "(Lme/ahoo/simba/core/MutexContender;Ljava/util/concurrent/Executor;Lme/ahoo/simba/jdbc/MutexOwnerRepository;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "executorService", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "contendPeriod", "Lme/ahoo/simba/core/ContendPeriod;", "contendScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "startContend", "", "nextSchedule", "nextDelay", "", "stopContend", "safeHandleContend", "contend", "Lme/ahoo/simba/core/MutexOwner;", "Companion", "simba-jdbc"})
public final class JdbcMutexContendService
extends AbstractMutexContendService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutexOwnerRepository mutexOwnerRepository;
    @NotNull
    private final Duration initialDelay;
    @NotNull
    private final Duration ttl;
    @NotNull
    private final Duration transition;
    @Nullable
    private ScheduledThreadPoolExecutor executorService;
    @NotNull
    private final ContendPeriod contendPeriod;
    @Nullable
    private volatile ScheduledFuture<?> contendScheduledFuture;
    private static final Logger log = LoggerFactory.getLogger(JdbcMutexContendService.class);

    public JdbcMutexContendService(@NotNull MutexContender mutexContender, @NotNull Executor handleExecutor, @NotNull MutexOwnerRepository mutexOwnerRepository, @NotNull Duration initialDelay, @NotNull Duration ttl, @NotNull Duration transition) {
        Intrinsics.checkNotNullParameter((Object)mutexContender, (String)"mutexContender");
        Intrinsics.checkNotNullParameter((Object)handleExecutor, (String)"handleExecutor");
        Intrinsics.checkNotNullParameter((Object)mutexOwnerRepository, (String)"mutexOwnerRepository");
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        super(mutexContender, handleExecutor);
        this.mutexOwnerRepository = mutexOwnerRepository;
        this.initialDelay = initialDelay;
        this.ttl = ttl;
        this.transition = transition;
        this.contendPeriod = new ContendPeriod(this.getContenderId());
    }

    protected void startContend() {
        this.executorService = new ScheduledThreadPoolExecutor(1, Threads.defaultFactory((String)("JdbcSimba_" + this.getMutex() + "_" + this.getContenderId())));
        this.nextSchedule(this.initialDelay.toMillis());
    }

    private final void nextSchedule(long nextDelay) {
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getMutex(), this.getContenderId(), nextDelay};
            log.debug("nextSchedule - mutex:[{}] contenderId:[{}] - nextDelay:[{}].", objectArray);
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.executorService;
        Intrinsics.checkNotNull((Object)scheduledThreadPoolExecutor);
        this.contendScheduledFuture = scheduledThreadPoolExecutor.schedule(() -> JdbcMutexContendService.nextSchedule$lambda$0(this), nextDelay, TimeUnit.MILLISECONDS);
    }

    protected void stopContend() {
        ScheduledFuture<?> scheduledFuture = this.contendScheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.executorService;
        if (scheduledThreadPoolExecutor != null) {
            scheduledThreadPoolExecutor.shutdown();
        }
        this.notifyOwner(MutexOwner.NONE);
        this.mutexOwnerRepository.release(this.getMutex(), this.getContenderId());
    }

    private final void safeHandleContend() {
        try {
            MutexOwner mutexOwner = this.contend();
            this.notifyOwner(mutexOwner);
            long nextDelay = this.contendPeriod.ensureNextDelay(mutexOwner);
            this.nextSchedule(nextDelay);
        }
        catch (Throwable throwable) {
            if (log.isErrorEnabled()) {
                log.error(throwable.getMessage(), throwable);
            }
            this.nextSchedule(this.ttl.toMillis());
        }
    }

    private final MutexOwner contend() {
        MutexOwnerEntity mutexOwner = this.mutexOwnerRepository.acquireAndGetOwner(this.getMutex(), this.getContenderId(), this.ttl.toMillis(), this.transition.toMillis());
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getMutex(), this.getContenderId(), mutexOwner.isOwner(this.getContenderId())};
            log.debug("contend - mutex:[{}] contenderId:[{}] - succeeded:[{}].", objectArray);
        }
        return mutexOwner;
    }

    private static final void nextSchedule$lambda$0(JdbcMutexContendService this$0) {
        this$0.safeHandleContend();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/simba/jdbc/JdbcMutexContendService$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "simba-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

