/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.boot.starter.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.spring.boot.starter.redis.ConditionalOnSimbaRedisEnabled;
import me.ahoo.simba.spring.boot.starter.redis.RedisProperties;
import me.ahoo.simba.spring.redis.SpringRedisMutexContendServiceFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@AutoConfiguration(after={RedisAutoConfiguration.class})
@ConditionalOnSimbaRedisEnabled
@ConditionalOnClass(value={StringRedisTemplate.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/simba/spring/boot/starter/redis/SimbaSpringRedisAutoConfiguration;", "", "redisProperties", "Lme/ahoo/simba/spring/boot/starter/redis/RedisProperties;", "(Lme/ahoo/simba/spring/boot/starter/redis/RedisProperties;)V", "redisMutexContendServiceFactory", "Lme/ahoo/simba/core/MutexContendServiceFactory;", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "listenerContainer", "Lorg/springframework/data/redis/listener/RedisMessageListenerContainer;", "simbaRedisMessageListenerContainer", "connectionFactory", "Lorg/springframework/data/redis/connection/RedisConnectionFactory;", "simba-spring-boot-starter"})
public class SimbaSpringRedisAutoConfiguration {
    @NotNull
    private final RedisProperties redisProperties;

    public SimbaSpringRedisAutoConfiguration(@NotNull RedisProperties redisProperties) {
        Intrinsics.checkNotNullParameter((Object)redisProperties, (String)"redisProperties");
        this.redisProperties = redisProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSingleCandidate(value=RedisConnectionFactory.class)
    @NotNull
    public RedisMessageListenerContainer simbaRedisMessageListenerContainer(@NotNull RedisConnectionFactory connectionFactory) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={StringRedisTemplate.class})
    @NotNull
    public MutexContendServiceFactory redisMutexContendServiceFactory(@NotNull StringRedisTemplate redisTemplate, @NotNull RedisMessageListenerContainer listenerContainer) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)listenerContainer, (String)"listenerContainer");
        return (MutexContendServiceFactory)new SpringRedisMutexContendServiceFactory(this.redisProperties.getTtl(), this.redisProperties.getTransition(), redisTemplate, listenerContainer, null, null, 48, null);
    }
}

