/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.boot.starter.jdbc;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.jdbc.JdbcMutexContendServiceFactory;
import me.ahoo.simba.jdbc.JdbcMutexOwnerRepository;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.spring.boot.starter.jdbc.ConditionalOnSimbaJdbcEnabled;
import me.ahoo.simba.spring.boot.starter.jdbc.JdbcProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnSimbaJdbcEnabled
@ConditionalOnClass(value={JdbcMutexContendServiceFactory.class})
@EnableConfigurationProperties(value={JdbcProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/simba/spring/boot/starter/jdbc/SimbaJdbcAutoConfiguration;", "", "jdbcProperties", "Lme/ahoo/simba/spring/boot/starter/jdbc/JdbcProperties;", "(Lme/ahoo/simba/spring/boot/starter/jdbc/JdbcProperties;)V", "jdbcMutexContendServiceFactory", "Lme/ahoo/simba/core/MutexContendServiceFactory;", "mutexOwnerRepository", "Lme/ahoo/simba/jdbc/MutexOwnerRepository;", "dataSource", "Ljavax/sql/DataSource;", "simba-spring-boot-starter"})
public class SimbaJdbcAutoConfiguration {
    @NotNull
    private final JdbcProperties jdbcProperties;

    public SimbaJdbcAutoConfiguration(@NotNull JdbcProperties jdbcProperties) {
        Intrinsics.checkNotNullParameter((Object)jdbcProperties, (String)"jdbcProperties");
        this.jdbcProperties = jdbcProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MutexOwnerRepository mutexOwnerRepository(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (MutexOwnerRepository)new JdbcMutexOwnerRepository(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MutexContendServiceFactory jdbcMutexContendServiceFactory(@NotNull MutexOwnerRepository mutexOwnerRepository) {
        Intrinsics.checkNotNullParameter((Object)mutexOwnerRepository, (String)"mutexOwnerRepository");
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        Intrinsics.checkNotNullExpressionValue((Object)forkJoinPool, (String)"commonPool(...)");
        return (MutexContendServiceFactory)new JdbcMutexContendServiceFactory(mutexOwnerRepository, (Executor)forkJoinPool, this.jdbcProperties.getInitialDelay(), this.jdbcProperties.getTtl(), this.jdbcProperties.getTransition());
    }
}

