/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.AbstractMutexContendService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.spring.redis.AcquireResult;
import me.ahoo.simba.spring.redis.OwnerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 42\u00020\u0001:\u000245B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u001a\u0010&\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\"H\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020 H\u0002J\b\u00100\u001a\u00020 H\u0014J\b\u00101\u001a\u00020 H\u0002J\b\u00102\u001a\u00020 H\u0014J\b\u00103\u001a\u00020 H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService;", "Lme/ahoo/simba/core/AbstractMutexContendService;", "contender", "Lme/ahoo/simba/core/MutexContender;", "handleExecutor", "Ljava/util/concurrent/Executor;", "ttl", "Ljava/time/Duration;", "transition", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "listenerContainer", "Lorg/springframework/data/redis/listener/RedisMessageListenerContainer;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lme/ahoo/simba/core/MutexContender;Ljava/util/concurrent/Executor;Ljava/time/Duration;Ljava/time/Duration;Lorg/springframework/data/redis/core/StringRedisTemplate;Lorg/springframework/data/redis/listener/RedisMessageListenerContainer;Ljava/util/concurrent/ScheduledExecutorService;)V", "contendPeriod", "Lme/ahoo/simba/core/ContendPeriod;", "contenderChannel", "", "keys", "", "listenTopics", "Lorg/springframework/data/redis/listener/ChannelTopic;", "mutexChannel", "mutexMessageListener", "Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$MutexMessageListener;", "scheduleFuture", "Ljava/util/concurrent/ScheduledFuture;", "Lme/ahoo/simba/core/MutexOwner;", "acquire", "disposeSchedule", "", "getTransitionAt", "", "message", "Lme/ahoo/simba/spring/redis/OwnerEvent;", "guard", "newMutexOwner", "ownerId", "transitionAt", "result", "Lme/ahoo/simba/spring/redis/AcquireResult;", "nextSchedule", "nextDelay", "notifyOwnerAndScheduleNext", "resultStr", "release", "startContend", "startSubscribe", "stopContend", "stopSubscribe", "Companion", "MutexMessageListener", "simba-spring-redis"})
public final class SpringRedisMutexContendService
extends AbstractMutexContendService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration ttl;
    @NotNull
    private final Duration transition;
    @NotNull
    private final StringRedisTemplate redisTemplate;
    @NotNull
    private final RedisMessageListenerContainer listenerContainer;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final List<String> keys;
    @NotNull
    private final String mutexChannel;
    @NotNull
    private final String contenderChannel;
    @NotNull
    private final List<ChannelTopic> listenTopics;
    @NotNull
    private final ContendPeriod contendPeriod;
    @NotNull
    private final MutexMessageListener mutexMessageListener;
    @Nullable
    private ScheduledFuture<MutexOwner> scheduleFuture;
    private static final Logger log = LoggerFactory.getLogger(SpringRedisMutexContendService.class);
    @NotNull
    private static final Resource ACQUIRE_RESOURCE = (Resource)new ClassPathResource("mutex_acquire.lua");
    @NotNull
    private static final RedisScript<String> SCRIPT_ACQUIRE;
    @NotNull
    private static final Resource RELEASE_RESOURCE;
    @NotNull
    private static final RedisScript<Boolean> SCRIPT_RELEASE;
    @NotNull
    private static final Resource GUARD_RESOURCE;
    @NotNull
    private static final RedisScript<String> SCRIPT_GUARD;

    public SpringRedisMutexContendService(@NotNull MutexContender contender, @NotNull Executor handleExecutor, @NotNull Duration ttl, @NotNull Duration transition, @NotNull StringRedisTemplate redisTemplate, @NotNull RedisMessageListenerContainer listenerContainer, @NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)contender, (String)"contender");
        Intrinsics.checkNotNullParameter((Object)handleExecutor, (String)"handleExecutor");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)listenerContainer, (String)"listenerContainer");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        super(contender, handleExecutor);
        this.ttl = ttl;
        this.transition = transition;
        this.redisTemplate = redisTemplate;
        this.listenerContainer = listenerContainer;
        this.scheduledExecutorService = scheduledExecutorService;
        this.keys = CollectionsKt.listOf((Object)("{" + contender.getMutex() + "}"));
        this.mutexChannel = "simba:" + contender.getMutex();
        this.contenderChannel = this.mutexChannel + ":" + contender.getContenderId();
        Object[] objectArray = new ChannelTopic[]{new ChannelTopic(this.mutexChannel), new ChannelTopic(this.contenderChannel)};
        this.listenTopics = CollectionsKt.listOf((Object[])objectArray);
        this.contendPeriod = new ContendPeriod(this.getContenderId());
        this.mutexMessageListener = new MutexMessageListener();
    }

    protected void startContend() {
        this.startSubscribe();
        this.nextSchedule(0L);
    }

    private final void startSubscribe() {
        this.listenerContainer.addMessageListener((MessageListener)this.mutexMessageListener, (Collection)this.listenTopics);
    }

    private final void nextSchedule(long nextDelay) {
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getMutex(), this.getContenderId(), nextDelay};
            log.debug("nextSchedule - mutex:[{}] contenderId:[{}] - nextDelay:[{}].", objectArray);
        }
        this.scheduleFuture = this.scheduledExecutorService.schedule(() -> SpringRedisMutexContendService.nextSchedule$lambda$0(this), nextDelay, TimeUnit.MILLISECONDS);
    }

    private final MutexOwner notifyOwnerAndScheduleNext(String resultStr) {
        MutexOwner mutexOwner;
        try {
            AcquireResult result = AcquireResult.Companion.of(resultStr);
            MutexOwner mutexOwner2 = this.newMutexOwner(result);
            this.notifyOwner(mutexOwner2);
            long nextDelay = this.contendPeriod.ensureNextDelay(mutexOwner2);
            this.nextSchedule(nextDelay);
            mutexOwner = mutexOwner2;
        }
        catch (Throwable throwable) {
            if (log.isErrorEnabled()) {
                log.error(throwable.getMessage(), throwable);
            }
            this.nextSchedule(this.ttl.toMillis());
            mutexOwner = MutexOwner.NONE;
        }
        return mutexOwner;
    }

    private final MutexOwner guard() {
        Object[] objectArray = new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis())};
        Object object = this.redisTemplate.execute(SCRIPT_GUARD, this.keys, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        String message = (String)object;
        if (log.isDebugEnabled()) {
            Object[] objectArray2 = new Object[]{this.getMutex(), this.getContenderId(), message};
            log.debug("guard - mutex:[{}] contenderId:[{}] - message:[{}].", objectArray2);
        }
        return this.notifyOwnerAndScheduleNext(message);
    }

    private final MutexOwner acquire() {
        Object[] objectArray = new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis() + this.transition.toMillis())};
        Object object = this.redisTemplate.execute(SCRIPT_ACQUIRE, this.keys, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        String message = (String)object;
        if (log.isDebugEnabled()) {
            Object[] objectArray2 = new Object[]{this.getMutex(), this.getContenderId(), message};
            log.debug("acquire - mutex:[{}] contenderId:[{}] - message:[{}].", objectArray2);
        }
        return this.notifyOwnerAndScheduleNext(message);
    }

    private final MutexOwner newMutexOwner(AcquireResult result) {
        return this.newMutexOwner(result.getOwnerId(), result.getTransitionAt());
    }

    private final MutexOwner newMutexOwner(String ownerId, long transitionAt) {
        long ttlAt = transitionAt - this.transition.toMillis();
        long acquiredAt = ttlAt - this.ttl.toMillis();
        String string = ownerId;
        Intrinsics.checkNotNull((Object)string);
        return new MutexOwner(string, acquiredAt, ttlAt, transitionAt);
    }

    private final long getTransitionAt(OwnerEvent message) {
        return message.getEventAt() + this.ttl.toMillis() + this.transition.toMillis();
    }

    protected void stopContend() {
        this.stopSubscribe();
        this.disposeSchedule();
        this.release();
    }

    private final void stopSubscribe() {
        this.listenerContainer.removeMessageListener((MessageListener)this.mutexMessageListener, (Collection)this.listenTopics);
    }

    private final void disposeSchedule() {
        block0: {
            ScheduledFuture<MutexOwner> scheduledFuture = this.scheduleFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    private final void release() {
        block3: {
            Object[] objectArray = new Object[]{this.getContenderId()};
            Object object = this.redisTemplate.execute(SCRIPT_RELEASE, this.keys, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
            boolean succeed = (Boolean)object;
            if (log.isDebugEnabled()) {
                Object[] objectArray2 = new Object[]{this.getMutex(), this.getContenderId(), succeed};
                log.debug("release - mutex:[{}] - contenderId:[{}] - succeed:[{}]", objectArray2);
            }
            try {
                this.notifyOwner(MutexOwner.NONE);
            }
            catch (Throwable throwable) {
                if (!log.isWarnEnabled()) break block3;
                objectArray = new Object[]{this.getMutex(), this.getContenderId(), throwable.getMessage()};
                log.warn("release - mutex:[{}] - contenderId:[{}] - message:[{}]", objectArray);
            }
        }
    }

    private static final MutexOwner nextSchedule$lambda$0(SpringRedisMutexContendService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.isOwner()) {
            return this$0.guard();
        }
        return this$0.acquire();
    }

    static {
        RedisScript redisScript = RedisScript.of((Resource)ACQUIRE_RESOURCE, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript, (String)"of(...)");
        SCRIPT_ACQUIRE = redisScript;
        RELEASE_RESOURCE = (Resource)new ClassPathResource("mutex_release.lua");
        RedisScript redisScript2 = RedisScript.of((Resource)RELEASE_RESOURCE, Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript2, (String)"of(...)");
        SCRIPT_RELEASE = redisScript2;
        GUARD_RESOURCE = (Resource)new ClassPathResource("mutex_guard.lua");
        RedisScript redisScript3 = RedisScript.of((Resource)GUARD_RESOURCE, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript3, (String)"of(...)");
        SCRIPT_GUARD = redisScript3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\r0\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$Companion;", "", "()V", "ACQUIRE_RESOURCE", "Lorg/springframework/core/io/Resource;", "GUARD_RESOURCE", "RELEASE_RESOURCE", "SCRIPT_ACQUIRE", "Lorg/springframework/data/redis/core/script/RedisScript;", "", "kotlin.jvm.PlatformType", "SCRIPT_GUARD", "SCRIPT_RELEASE", "", "log", "Lorg/slf4j/Logger;", "simba-spring-redis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$MutexMessageListener;", "Lorg/springframework/data/redis/connection/MessageListener;", "(Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService;)V", "onMessage", "", "message", "Lorg/springframework/data/redis/connection/Message;", "pattern", "", "simba-spring-redis"})
    public final class MutexMessageListener
    implements MessageListener {
        public void onMessage(@NotNull Message message, @Nullable byte[] pattern) {
            OwnerEvent ownerEvent;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            byte[] byArray = message.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getChannel(...)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object[] objectArray = charset;
            String channel = new String(byArray2, (Charset)objectArray);
            byte[] byArray3 = message.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBody(...)");
            objectArray = byArray3;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            Object object = charset2;
            String body = new String((byte[])objectArray, (Charset)object);
            if (log.isDebugEnabled()) {
                objectArray = new Object[]{SpringRedisMutexContendService.this.getMutex(), SpringRedisMutexContendService.this.getContenderId(), channel, body};
                log.debug("onMessage - mutex:[{}] - contenderId:[{}] - channel:[{}] - message:[{}].", objectArray);
            }
            if (Intrinsics.areEqual((Object)(object = (ownerEvent = OwnerEvent.Companion.of(body)).getEvent()), (Object)"released")) {
                SpringRedisMutexContendService.this.notifyOwner(MutexOwner.NONE);
                SpringRedisMutexContendService.this.acquire();
            } else if (Intrinsics.areEqual((Object)object, (Object)"acquired")) {
                SpringRedisMutexContendService.this.notifyOwner(SpringRedisMutexContendService.this.newMutexOwner(ownerEvent.getOwnerId(), SpringRedisMutexContendService.this.getTransitionAt(ownerEvent)));
            } else {
                throw new IllegalStateException("Unexpected value: " + ownerEvent.getEvent());
            }
        }
    }
}

