/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.simba.core.AbstractMutexContendService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.spring.redis.AcquireResult;
import me.ahoo.simba.spring.redis.OwnerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u000256B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010)\u001a\u00020\u001e2\b\u0010,\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020$H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020 H\u0014J\b\u00102\u001a\u00020 H\u0002J\b\u00103\u001a\u00020 H\u0002J\b\u00104\u001a\u00020 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService;", "Lme/ahoo/simba/core/AbstractMutexContendService;", "contender", "Lme/ahoo/simba/core/MutexContender;", "handleExecutor", "Ljava/util/concurrent/Executor;", "ttl", "Ljava/time/Duration;", "transition", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "listenerContainer", "Lorg/springframework/data/redis/listener/RedisMessageListenerContainer;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(Lme/ahoo/simba/core/MutexContender;Ljava/util/concurrent/Executor;Ljava/time/Duration;Ljava/time/Duration;Lorg/springframework/data/redis/core/StringRedisTemplate;Lorg/springframework/data/redis/listener/RedisMessageListenerContainer;Ljava/util/concurrent/ScheduledExecutorService;)V", "keys", "", "", "mutexChannel", "contenderChannel", "listenTopics", "Lorg/springframework/data/redis/listener/ChannelTopic;", "contendPeriod", "Lme/ahoo/simba/core/ContendPeriod;", "mutexMessageListener", "Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$MutexMessageListener;", "scheduleFuture", "Ljava/util/concurrent/ScheduledFuture;", "Lme/ahoo/simba/core/MutexOwner;", "startContend", "", "startSubscribe", "nextSchedule", "nextDelay", "", "notifyOwnerAndScheduleNext", "resultStr", "guard", "acquire", "newMutexOwner", "result", "Lme/ahoo/simba/spring/redis/AcquireResult;", "ownerId", "transitionAt", "getTransitionAt", "message", "Lme/ahoo/simba/spring/redis/OwnerEvent;", "stopContend", "stopSubscribe", "disposeSchedule", "release", "Companion", "MutexMessageListener", "simba-spring-redis"})
public final class SpringRedisMutexContendService
extends AbstractMutexContendService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration ttl;
    @NotNull
    private final Duration transition;
    @NotNull
    private final StringRedisTemplate redisTemplate;
    @NotNull
    private final RedisMessageListenerContainer listenerContainer;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final List<String> keys;
    @NotNull
    private final String mutexChannel;
    @NotNull
    private final String contenderChannel;
    @NotNull
    private final List<ChannelTopic> listenTopics;
    @NotNull
    private final ContendPeriod contendPeriod;
    @NotNull
    private final MutexMessageListener mutexMessageListener;
    @Nullable
    private ScheduledFuture<MutexOwner> scheduleFuture;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(SpringRedisMutexContendService::log$lambda$11);
    @NotNull
    private static final Resource ACQUIRE_RESOURCE = (Resource)new ClassPathResource("mutex_acquire.lua");
    @NotNull
    private static final RedisScript<String> SCRIPT_ACQUIRE;
    @NotNull
    private static final Resource RELEASE_RESOURCE;
    @NotNull
    private static final RedisScript<Boolean> SCRIPT_RELEASE;
    @NotNull
    private static final Resource GUARD_RESOURCE;
    @NotNull
    private static final RedisScript<String> SCRIPT_GUARD;

    public SpringRedisMutexContendService(@NotNull MutexContender contender, @NotNull Executor handleExecutor, @NotNull Duration ttl, @NotNull Duration transition, @NotNull StringRedisTemplate redisTemplate, @NotNull RedisMessageListenerContainer listenerContainer, @NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)contender, (String)"contender");
        Intrinsics.checkNotNullParameter((Object)handleExecutor, (String)"handleExecutor");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)listenerContainer, (String)"listenerContainer");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        super(contender, handleExecutor);
        this.ttl = ttl;
        this.transition = transition;
        this.redisTemplate = redisTemplate;
        this.listenerContainer = listenerContainer;
        this.scheduledExecutorService = scheduledExecutorService;
        this.keys = CollectionsKt.listOf((Object)("{" + contender.getMutex() + "}"));
        this.mutexChannel = "simba:" + contender.getMutex();
        this.contenderChannel = this.mutexChannel + ":" + contender.getContenderId();
        Object[] objectArray = new ChannelTopic[]{new ChannelTopic(this.mutexChannel), new ChannelTopic(this.contenderChannel)};
        this.listenTopics = CollectionsKt.listOf((Object[])objectArray);
        this.contendPeriod = new ContendPeriod(this.getContenderId());
        this.mutexMessageListener = new MutexMessageListener();
    }

    protected void startContend() {
        log.info(() -> SpringRedisMutexContendService.startContend$lambda$0(this));
        this.startSubscribe();
        this.nextSchedule(0L);
    }

    private final void startSubscribe() {
        this.listenerContainer.addMessageListener((MessageListener)this.mutexMessageListener, (Collection)this.listenTopics);
    }

    private final void nextSchedule(long nextDelay) {
        log.debug(() -> SpringRedisMutexContendService.nextSchedule$lambda$1(this, nextDelay));
        if (!this.getStatus().isActive()) {
            log.warn(() -> SpringRedisMutexContendService.nextSchedule$lambda$2(this));
            return;
        }
        this.scheduleFuture = this.scheduledExecutorService.schedule(() -> SpringRedisMutexContendService.nextSchedule$lambda$3(this), nextDelay, TimeUnit.MILLISECONDS);
    }

    private final MutexOwner notifyOwnerAndScheduleNext(String resultStr) {
        MutexOwner mutexOwner;
        try {
            AcquireResult result = AcquireResult.Companion.of(resultStr);
            MutexOwner mutexOwner2 = this.newMutexOwner(result);
            this.notifyOwner(mutexOwner2);
            long nextDelay = this.contendPeriod.ensureNextDelay(mutexOwner2);
            this.nextSchedule(nextDelay);
            mutexOwner = mutexOwner2;
        }
        catch (Throwable throwable) {
            log.error(throwable, () -> SpringRedisMutexContendService.notifyOwnerAndScheduleNext$lambda$4(this));
            this.nextSchedule(this.ttl.toMillis());
            mutexOwner = MutexOwner.NONE;
        }
        return mutexOwner;
    }

    private final MutexOwner guard() {
        Object[] objectArray = new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis())};
        Object object = this.redisTemplate.execute(SCRIPT_GUARD, this.keys, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        String message = (String)object;
        log.debug(() -> SpringRedisMutexContendService.guard$lambda$5(this, message));
        return this.notifyOwnerAndScheduleNext(message);
    }

    private final MutexOwner acquire() {
        Object[] objectArray = new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis() + this.transition.toMillis())};
        Object object = this.redisTemplate.execute(SCRIPT_ACQUIRE, this.keys, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        String message = (String)object;
        log.debug(() -> SpringRedisMutexContendService.acquire$lambda$6(this, message));
        return this.notifyOwnerAndScheduleNext(message);
    }

    private final MutexOwner newMutexOwner(AcquireResult result) {
        return this.newMutexOwner(result.getOwnerId(), result.getTransitionAt());
    }

    private final MutexOwner newMutexOwner(String ownerId, long transitionAt) {
        long ttlAt = transitionAt - this.transition.toMillis();
        long acquiredAt = ttlAt - this.ttl.toMillis();
        String string = ownerId;
        Intrinsics.checkNotNull((Object)string);
        return new MutexOwner(string, acquiredAt, ttlAt, transitionAt);
    }

    private final long getTransitionAt(OwnerEvent message) {
        return message.getEventAt() + this.ttl.toMillis() + this.transition.toMillis();
    }

    protected void stopContend() {
        log.info(() -> SpringRedisMutexContendService.stopContend$lambda$7(this));
        this.stopSubscribe();
        this.disposeSchedule();
        this.release();
    }

    private final void stopSubscribe() {
        this.listenerContainer.removeMessageListener((MessageListener)this.mutexMessageListener, (Collection)this.listenTopics);
    }

    private final void disposeSchedule() {
        block0: {
            ScheduledFuture<MutexOwner> scheduledFuture = this.scheduleFuture;
            if (scheduledFuture == null) break block0;
            ScheduledFuture<MutexOwner> it = scheduledFuture;
            boolean bl = false;
            it.cancel(true);
            this.scheduleFuture = null;
        }
    }

    private final void release() {
        Object[] objectArray = new Object[]{this.getContenderId()};
        Object object = this.redisTemplate.execute(SCRIPT_RELEASE, this.keys, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        boolean succeed = (Boolean)object;
        log.debug(() -> SpringRedisMutexContendService.release$lambda$9(this, succeed));
        try {
            this.notifyOwner(MutexOwner.NONE);
        }
        catch (Throwable throwable) {
            log.warn(throwable, () -> SpringRedisMutexContendService.release$lambda$10(this));
        }
    }

    private static final Object startContend$lambda$0(SpringRedisMutexContendService this$0) {
        return "startContend - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "].";
    }

    private static final Object nextSchedule$lambda$1(SpringRedisMutexContendService this$0, long $nextDelay) {
        return "nextSchedule - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] status:[" + this$0.getStatus() + "] delay:[" + $nextDelay + "ms].";
    }

    private static final Object nextSchedule$lambda$2(SpringRedisMutexContendService this$0) {
        return "nextSchedule - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] is not active[" + this$0.getStatus() + "].";
    }

    private static final MutexOwner nextSchedule$lambda$3(SpringRedisMutexContendService this$0) {
        if (this$0.isOwner()) {
            return this$0.guard();
        }
        return this$0.acquire();
    }

    private static final Object notifyOwnerAndScheduleNext$lambda$4(SpringRedisMutexContendService this$0) {
        return "notifyOwnerAndScheduleNext - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] error.";
    }

    private static final Object guard$lambda$5(SpringRedisMutexContendService this$0, String $message) {
        return "guard - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] - message:[" + $message + "].";
    }

    private static final Object acquire$lambda$6(SpringRedisMutexContendService this$0, String $message) {
        return "acquire - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] - message:[" + $message + "].";
    }

    private static final Object stopContend$lambda$7(SpringRedisMutexContendService this$0) {
        return "stopContend - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "].";
    }

    private static final Object release$lambda$9(SpringRedisMutexContendService this$0, boolean $succeed) {
        return "release - mutex:[" + this$0.getMutex() + "] - contenderId:[" + this$0.getContenderId() + "] - succeed:[" + $succeed + "]";
    }

    private static final Object release$lambda$10(SpringRedisMutexContendService this$0) {
        return "release - mutex:[" + this$0.getMutex() + "] - contenderId:[" + this$0.getContenderId() + "] - error.";
    }

    private static final Unit log$lambda$11() {
        return Unit.INSTANCE;
    }

    static {
        RedisScript redisScript = RedisScript.of((Resource)ACQUIRE_RESOURCE, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript, (String)"of(...)");
        SCRIPT_ACQUIRE = redisScript;
        RELEASE_RESOURCE = (Resource)new ClassPathResource("mutex_release.lua");
        RedisScript redisScript2 = RedisScript.of((Resource)RELEASE_RESOURCE, Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript2, (String)"of(...)");
        SCRIPT_RELEASE = redisScript2;
        GUARD_RESOURCE = (Resource)new ClassPathResource("mutex_guard.lua");
        RedisScript redisScript3 = RedisScript.of((Resource)GUARD_RESOURCE, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)redisScript3, (String)"of(...)");
        SCRIPT_GUARD = redisScript3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000e0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "ACQUIRE_RESOURCE", "Lorg/springframework/core/io/Resource;", "SCRIPT_ACQUIRE", "Lorg/springframework/data/redis/core/script/RedisScript;", "", "kotlin.jvm.PlatformType", "RELEASE_RESOURCE", "SCRIPT_RELEASE", "", "GUARD_RESOURCE", "SCRIPT_GUARD", "simba-spring-redis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService$MutexMessageListener;", "Lorg/springframework/data/redis/connection/MessageListener;", "<init>", "(Lme/ahoo/simba/spring/redis/SpringRedisMutexContendService;)V", "onMessage", "", "message", "Lorg/springframework/data/redis/connection/Message;", "pattern", "", "simba-spring-redis"})
    public final class MutexMessageListener
    implements MessageListener {
        public void onMessage(@NotNull Message message, @Nullable byte[] pattern) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (!SpringRedisMutexContendService.this.getStatus().isActive()) {
                log.warn(() -> MutexMessageListener.onMessage$lambda$0(SpringRedisMutexContendService.this));
                return;
            }
            byte[] byArray = message.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getChannel(...)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            String channel = new String(byArray2, (Charset)object);
            byte[] byArray3 = message.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBody(...)");
            object = byArray3;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            Object object2 = charset2;
            String body = new String((byte[])object, (Charset)object2);
            log.debug(() -> MutexMessageListener.onMessage$lambda$1(SpringRedisMutexContendService.this, channel, body));
            OwnerEvent ownerEvent = OwnerEvent.Companion.of(body);
            object2 = ownerEvent.getEvent();
            if (Intrinsics.areEqual((Object)object2, (Object)"released")) {
                SpringRedisMutexContendService.this.notifyOwner(MutexOwner.NONE);
                v4 = SpringRedisMutexContendService.this.acquire();
            } else if (Intrinsics.areEqual((Object)object2, (Object)"acquired")) {
                v4 = SpringRedisMutexContendService.this.notifyOwner(SpringRedisMutexContendService.this.newMutexOwner(ownerEvent.getOwnerId(), SpringRedisMutexContendService.this.getTransitionAt(ownerEvent)));
            } else {
                throw new IllegalStateException("Unexpected value: " + ownerEvent.getEvent());
            }
        }

        private static final Object onMessage$lambda$0(SpringRedisMutexContendService this$0) {
            return "onMessage - ignore - mutex:[" + this$0.getMutex() + "] contenderId:[" + this$0.getContenderId() + "] is not active[" + this$0.getStatus() + "].";
        }

        private static final Object onMessage$lambda$1(SpringRedisMutexContendService this$0, String $channel, String $body) {
            return "onMessage - mutex:[" + this$0.getMutex() + "] - contenderId:[" + this$0.getContenderId() + "] - channel:[" + $channel + "] - message:[" + $body + "].";
        }
    }
}

