/*
 * Decompiled with CFR 0.152.
 */
package me.alexpanov.retries;

import com.google.common.base.Optional;
import java.util.Collection;
import me.alexpanov.retries.EmptyRetryFailure;
import me.alexpanov.retries.FailedToComputeAValueException;
import me.alexpanov.retries.FailureSubscriber;
import me.alexpanov.retries.PerformedWork;
import me.alexpanov.retries.Retryable;
import me.alexpanov.retries.StopCriteria;
import me.alexpanov.retries.Wait;

final class ExecutionOfRetryable<Result> {
    private final Retryable<Result> retryable;
    private final Optional<Result> defaultResult;
    private final Collection<FailureSubscriber<Result>> failureSubscribers;
    private final StopCriteria<Result> stopCriteria;
    private final long timeout;

    ExecutionOfRetryable(Retryable<Result> retryable, Optional<Result> defaultResult, Collection<FailureSubscriber<Result>> failureSubscribers, StopCriteria<Result> stopCriteria, long timeout) {
        this.retryable = retryable;
        this.defaultResult = defaultResult;
        this.failureSubscribers = failureSubscribers;
        this.stopCriteria = stopCriteria;
        this.timeout = timeout;
    }

    Result perform() {
        PerformedWork<Result> performedWork = this.stopCriteria.startNewWork();
        return this.computeResult(performedWork);
    }

    private Result computeResult(PerformedWork<Result> performedWork) {
        Optional<Result> result = this.obtainResultOfOneTry();
        PerformedWork<Result> workAfterCurrentTry = performedWork.tryEndedIn(result);
        if (workAfterCurrentTry.isDone()) {
            return this.workResult(workAfterCurrentTry);
        }
        this.handleFailure();
        return this.computeResult(workAfterCurrentTry);
    }

    private Result workResult(PerformedWork<Result> performedWork) {
        Optional workResult = performedWork.workResult().or(this.defaultResult);
        if (workResult.isPresent()) {
            return (Result)workResult.get();
        }
        throw new FailedToComputeAValueException();
    }

    private Optional<Result> obtainResultOfOneTry() {
        try {
            return Optional.fromNullable(this.retryable.tryOnce());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private void handleFailure() {
        this.notifyOfFailure();
        this.waitForAtLeastSpecifiedTime();
    }

    private void notifyOfFailure() {
        EmptyRetryFailure retryFailure = new EmptyRetryFailure();
        for (FailureSubscriber failureSubscriber : this.failureSubscribers) {
            failureSubscriber.onFailure(retryFailure);
        }
    }

    private void waitForAtLeastSpecifiedTime() {
        new Wait(this.timeout).perform();
    }
}

