/*
 * Decompiled with CFR 0.152.
 */
package me.alexpanov.retries;

import com.google.common.base.Optional;
import me.alexpanov.retries.RetriesCount;
import me.alexpanov.retries.StopCriteria;

final class PerformedWork<Result> {
    private final RetriesCount retriesCount;
    private final StopCriteria<Result> stopCriteria;
    private final Optional<Result> lastResult;

    PerformedWork(RetriesCount retriesCount, StopCriteria<Result> stopCriteria) {
        this(stopCriteria, Optional.absent(), retriesCount);
    }

    private PerformedWork(StopCriteria<Result> stopCriteria, Optional<Result> lastResult, RetriesCount retriesCount) {
        this.stopCriteria = stopCriteria;
        this.lastResult = lastResult;
        this.retriesCount = retriesCount;
    }

    PerformedWork<Result> tryEndedIn(Optional<Result> result) {
        return new PerformedWork<Result>(this.stopCriteria, result, this.retriesCount.increment());
    }

    Optional<Result> lastResult() {
        return this.lastResult;
    }

    boolean isDone() {
        return this.retriesCount.isMaxReached() || !this.stopCriteria.shouldContinue(this.lastResult());
    }

    Optional<Result> workResult() {
        if (this.stopCriteria.shouldContinue(this.lastResult())) {
            return Optional.absent();
        }
        return this.lastResult();
    }
}

