/*
 * Decompiled with CFR 0.152.
 */
package me.alexpanov.retries;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import me.alexpanov.retries.FailureSubscriber;
import me.alexpanov.retries.RetryException;
import me.alexpanov.retries.RetryRuntime;
import me.alexpanov.retries.Retryable;

public final class Retries<Result> {
    private final Retryable<Result> retryable;
    private final RetryRuntime<Result> runtime;

    public Retries(Retryable<Result> retryable) {
        this(retryable, new RetryRuntime());
    }

    private Retries(Retryable<Result> retryable, RetryRuntime<Result> runtime) {
        Preconditions.checkNotNull(retryable);
        Preconditions.checkNotNull(runtime);
        this.retryable = retryable;
        this.runtime = runtime;
    }

    public Retries<Result> stopOnMaxFailures(int maxRetries) {
        return new Retries<Result>(this.retryable, this.runtime.maxRetries(maxRetries));
    }

    public Retries<Result> orElse(Result value) {
        Preconditions.checkNotNull(value);
        return new Retries<Result>(this.retryable, this.runtime.defaultResult(Optional.of(value)));
    }

    public Retries<Result> ignoreIfResult(Predicate<? super Result> matches) {
        Preconditions.checkNotNull(matches);
        return new Retries<Result>(this.retryable, this.runtime.ignoreIfResult(matches));
    }

    public Retries<Result> onEachFailureDo(FailureSubscriber<Result> failureSubscriber) {
        Preconditions.checkNotNull(failureSubscriber);
        return new Retries<Result>(this.retryable, this.runtime.onEachFailure(failureSubscriber));
    }

    public Retries<Result> waitAfterFailureAtLeast(int timeout, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        return new Retries<Result>(this.retryable, this.runtime.waitAtLeast(timeUnit.toMillis(timeout)));
    }

    public Result perform() throws RetryException {
        return this.runtime.perform(this.retryable);
    }

    public Future<Result> performAsync() {
        Callable callable = new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return Retries.this.perform();
            }
        };
        return Executors.newSingleThreadExecutor().submit(callable);
    }
}

