/*
 * Decompiled with CFR 0.152.
 */
package me.alexpanov.retries;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import me.alexpanov.retries.ExecutionOfRetryable;
import me.alexpanov.retries.FailureSubscriber;
import me.alexpanov.retries.Retryable;
import me.alexpanov.retries.StopCriteria;

final class RetryRuntime<Result> {
    private final Optional<Result> defaultResult;
    private final Collection<FailureSubscriber<Result>> failureSubscribers;
    private final StopCriteria<Result> stopCriteria;
    private final long timeout;

    RetryRuntime() {
        this(Optional.absent(), Collections.emptyList(), new StopCriteria(), 0L);
    }

    RetryRuntime(Optional<Result> defaultResult, Collection<FailureSubscriber<Result>> failureSubscribers, StopCriteria<Result> stopCriteria, long timeout) {
        this.defaultResult = defaultResult;
        this.failureSubscribers = failureSubscribers;
        this.stopCriteria = stopCriteria;
        this.timeout = timeout;
    }

    Result perform(Retryable<Result> retryable) {
        return new ExecutionOfRetryable<Result>(retryable, this.defaultResult, this.failureSubscribers, this.stopCriteria, this.timeout).perform();
    }

    RetryRuntime<Result> defaultResult(Optional<Result> defaultResult) {
        Preconditions.checkArgument((boolean)defaultResult.isPresent(), (Object)"Default result must be present");
        Preconditions.checkState((!this.defaultResult.isPresent() ? 1 : 0) != 0, (Object)"Cannot specify two default results");
        return new RetryRuntime<Result>(defaultResult, this.failureSubscribers, this.stopCriteria, this.timeout);
    }

    RetryRuntime<Result> maxRetries(int maxRetries) {
        return new RetryRuntime<Result>(this.defaultResult, this.failureSubscribers, this.stopCriteria.maxRetries(maxRetries), this.timeout);
    }

    RetryRuntime<Result> ignoreIfResult(Predicate<? super Result> ignoreRule) {
        return new RetryRuntime<Result>(this.defaultResult, this.failureSubscribers, this.stopCriteria.withContinueOnResultRule(ignoreRule), this.timeout);
    }

    RetryRuntime<Result> onEachFailure(FailureSubscriber<Result> failureSubscriber) {
        LinkedList failureSubscribers = Lists.newLinkedList(this.failureSubscribers);
        failureSubscribers.add(failureSubscriber);
        return new RetryRuntime<Result>(this.defaultResult, failureSubscribers, this.stopCriteria, this.timeout);
    }

    RetryRuntime<Result> waitAtLeast(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0);
        return new RetryRuntime<Result>(this.defaultResult, this.failureSubscribers, this.stopCriteria, timeout);
    }
}

