/*
 * Decompiled with CFR 0.152.
 */
package me.alexpanov.retries;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import me.alexpanov.retries.PerformedWork;
import me.alexpanov.retries.ResultNotPresentRule;
import me.alexpanov.retries.RetriesCount;

final class StopCriteria<Result> {
    private final Predicate<Optional<Result>> rules;
    private final int maxRetries;

    StopCriteria() {
        this(2, new ResultNotPresentRule());
    }

    private StopCriteria(int maxRetries, Predicate<Optional<Result>> rules) {
        this.maxRetries = maxRetries;
        this.rules = rules;
    }

    boolean shouldContinue(Optional<Result> result) {
        return this.rules.apply(result);
    }

    StopCriteria<Result> withContinueOnResultRule(Predicate<? super Result> continueOnResultRule) {
        Predicate<Optional<? super Result>> newRule = this.toOptionalResultRule(continueOnResultRule);
        return this.withContinueRule(newRule);
    }

    private Predicate<Optional<Result>> toOptionalResultRule(final Predicate<? super Result> continueOnResultRule) {
        return new Predicate<Optional<Result>>(){

            public boolean apply(Optional<Result> lastResult) {
                return continueOnResultRule.apply(lastResult.get());
            }
        };
    }

    private StopCriteria<Result> withContinueRule(Predicate<Optional<Result>> rule) {
        Predicate newRules = Predicates.or(this.rules, rule);
        return new StopCriteria<Result>(this.maxRetries, newRules);
    }

    StopCriteria<Result> maxRetries(int maxRetries) {
        return new StopCriteria<Result>(maxRetries, this.rules);
    }

    PerformedWork<Result> startNewWork() {
        return new PerformedWork(new RetriesCount(this.maxRetries), this);
    }
}

