/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.alidg.errors.ExceptionLogger;
import me.alidg.errors.ExceptionRefiner;
import me.alidg.errors.FingerprintProvider;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.WebErrorHandlerPostProcessor;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.conf.ErrorsProperties;
import me.alidg.errors.fingerprint.UuidFingerprintProvider;
import me.alidg.errors.handlers.LastResortWebErrorHandler;
import org.springframework.context.MessageSource;
import org.springframework.lang.NonNull;

public final class WebErrorHandlersBuilder {
    private final MessageSource messageSource;
    private final List<WebErrorHandler> webErrorHandlers = new ArrayList<WebErrorHandler>();
    private final List<WebErrorHandlerPostProcessor> webErrorHandlerPostProcessors = new ArrayList<WebErrorHandlerPostProcessor>();
    private ErrorsProperties errorsProperties = new ErrorsProperties();
    private WebErrorHandler defaultWebErrorHandler = LastResortWebErrorHandler.INSTANCE;
    private ExceptionRefiner exceptionRefiner = ExceptionRefiner.NoOp.INSTANCE;
    private ExceptionLogger exceptionLogger = ExceptionLogger.NoOp.INSTANCE;
    private FingerprintProvider fingerprintProvider = new UuidFingerprintProvider();

    WebErrorHandlersBuilder(@NonNull MessageSource messageSource) {
        this.messageSource = Objects.requireNonNull(messageSource, "Message source is required to create WebErrorHandlers instance");
    }

    public WebErrorHandlersBuilder withErrorsProperties(@NonNull ErrorsProperties errorsProperties) {
        this.errorsProperties = Objects.requireNonNull(errorsProperties, "Error properties is required to create WebErrorHandlers instance");
        if (errorsProperties.getExposeArguments() == null) {
            errorsProperties.setExposeArguments(ErrorsProperties.ArgumentExposure.NEVER);
        }
        return this;
    }

    public WebErrorHandlersBuilder withErrorHandlers(@NonNull Collection<WebErrorHandler> webErrorHandlers) {
        this.webErrorHandlers.addAll(Objects.requireNonNull(webErrorHandlers, "Web error handlers are required to create WebErrorHandlers instance"));
        return this;
    }

    public WebErrorHandlersBuilder withErrorHandlers(WebErrorHandler ... webErrorHandlers) {
        return this.withErrorHandlers(Arrays.asList((Object[])Objects.requireNonNull(webErrorHandlers, "Web error handlers are required to create WebErrorHandlers instance")));
    }

    public WebErrorHandlersBuilder withDefaultWebErrorHandler(@NonNull WebErrorHandler defaultWebErrorHandler) {
        this.defaultWebErrorHandler = Objects.requireNonNull(defaultWebErrorHandler, "Default web error handler is required to create WebErrorHandlers instance");
        return this;
    }

    public WebErrorHandlersBuilder withExceptionRefiner(@NonNull ExceptionRefiner exceptionRefiner) {
        this.exceptionRefiner = Objects.requireNonNull(exceptionRefiner, "An exception refiner is required to create WebErrorHandlers instance");
        return this;
    }

    public WebErrorHandlersBuilder withExceptionLogger(@NonNull ExceptionLogger exceptionLogger) {
        this.exceptionLogger = Objects.requireNonNull(exceptionLogger, "An exception logger is required to create WebErrorHandlers instance");
        return this;
    }

    public WebErrorHandlersBuilder withPostProcessors(@NonNull Collection<WebErrorHandlerPostProcessor> webErrorHandlerPostProcessors) {
        this.webErrorHandlerPostProcessors.addAll(Objects.requireNonNull(webErrorHandlerPostProcessors, "Post processors are required to create WebErrorHandlers instance"));
        return this;
    }

    public WebErrorHandlersBuilder withPostProcessors(WebErrorHandlerPostProcessor ... webErrorHandlerPostProcessors) {
        return this.withPostProcessors(Arrays.asList((Object[])Objects.requireNonNull(webErrorHandlerPostProcessors, "Post processors are required to create WebErrorHandlers instance")));
    }

    public WebErrorHandlersBuilder withFingerprintProvider(@NonNull FingerprintProvider fingerprintProvider) {
        this.fingerprintProvider = Objects.requireNonNull(fingerprintProvider, "Fingerprint provider is required to create WebErrorHandlers instance");
        return this;
    }

    @NonNull
    public WebErrorHandlers build() {
        return new WebErrorHandlers(this.messageSource, this.webErrorHandlers, this.defaultWebErrorHandler, this.exceptionRefiner, this.exceptionLogger, this.webErrorHandlerPostProcessors, this.fingerprintProvider, this.errorsProperties);
    }
}

