/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.alidg.errors.HttpError;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.conf.ErrorsProperties;
import org.springframework.lang.NonNull;

public class DefaultHttpErrorAttributesAdapter
implements HttpErrorAttributesAdapter {
    private final ErrorsProperties errorsProperties;

    public DefaultHttpErrorAttributesAdapter(ErrorsProperties errorsProperties) {
        this.errorsProperties = errorsProperties;
    }

    @Override
    @NonNull
    public Map<String, Object> adapt(@NonNull HttpError httpError) {
        return httpError.getErrors().stream().map(this::toMap).collect(Collectors.collectingAndThen(Collectors.toList(), errors -> this.errorDetails(errors, httpError)));
    }

    private Map<String, Object> errorDetails(Object errors, HttpError httpError) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errors", errors);
        if (httpError.getFingerprint() != null) {
            map.put("fingerprint", httpError.getFingerprint());
        }
        return map;
    }

    private Map<String, Object> toMap(HttpError.CodedMessage codedMessage) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", codedMessage.getCode());
        error.put("message", codedMessage.getMessage());
        this.errorsProperties.getExposeArguments().expose(error, codedMessage.getArguments());
        return error;
    }
}

