/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.adapter.attributes;

import java.util.Map;
import me.alidg.errors.annotation.ExceptionMapping;
import me.alidg.errors.annotation.ExposeAsArg;
import org.springframework.http.HttpStatus;

class Exceptions {
    Exceptions() {
    }

    static Exception refineUnknownException(Map<String, Object> attributes) {
        switch (Exceptions.getStatusCode(attributes)) {
            case 401: {
                return new UnauthorizedException();
            }
            case 403: {
                return new ForbiddenException();
            }
            case 404: {
                return new HandlerNotFoundException(Exceptions.getPath(attributes));
            }
        }
        return new IllegalStateException("The exception is null: " + attributes);
    }

    private static String getPath(Map<String, Object> attributes) {
        Object path = attributes.get("path");
        return path == null ? "unknown" : path.toString();
    }

    private static int getStatusCode(Map<String, Object> attributes) {
        try {
            return (Integer)attributes.getOrDefault("status", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @ExceptionMapping(statusCode=HttpStatus.NOT_FOUND, errorCode="web.no_handler")
    private static final class HandlerNotFoundException
    extends RuntimeException {
        @ExposeAsArg(value=0)
        private final String path;

        private HandlerNotFoundException(String path) {
            this.path = path;
        }
    }

    @ExceptionMapping(statusCode=HttpStatus.FORBIDDEN, errorCode="security.access_denied")
    private static final class ForbiddenException
    extends RuntimeException {
        private ForbiddenException() {
        }
    }

    @ExceptionMapping(statusCode=HttpStatus.UNAUTHORIZED, errorCode="security.auth_required")
    private static final class UnauthorizedException
    extends RuntimeException {
        private UnauthorizedException() {
        }
    }
}

