/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.adapter.attributes;

import java.util.Map;
import java.util.Objects;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.adapter.attributes.Exceptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public class ServletErrorAttributes
extends DefaultErrorAttributes {
    private static final String STATUS_CODE_ATTR = "javax.servlet.error.status_code";
    private final WebErrorHandlers webErrorHandlers;
    private final HttpErrorAttributesAdapter httpErrorAttributesAdapter;

    public ServletErrorAttributes(WebErrorHandlers webErrorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        Objects.requireNonNull(webErrorHandlers, "Web error handlers is required");
        Objects.requireNonNull(httpErrorAttributesAdapter, "Adapter is required");
        this.webErrorHandlers = webErrorHandlers;
        this.httpErrorAttributesAdapter = httpErrorAttributesAdapter;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map attributes = super.getErrorAttributes(webRequest, includeStackTrace);
        Throwable exception = this.getError(webRequest);
        if (exception == null) {
            exception = Exceptions.refineUnknownException(attributes);
        }
        HttpError httpError = this.webErrorHandlers.handle(exception, webRequest, webRequest.getLocale());
        this.saveStatusCodeInRequest(webRequest, httpError);
        return this.httpErrorAttributesAdapter.adapt(httpError);
    }

    private void saveStatusCodeInRequest(WebRequest webRequest, HttpError httpError) {
        int statusCode = httpError.getHttpStatus().value();
        webRequest.setAttribute(STATUS_CODE_ATTR, (Object)statusCode, 0);
    }
}

