/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.conf;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(name={"org.springframework.security.web.access.AccessDeniedHandler"})
public class ServletSecurityErrorsAutoConfiguration {
    private static final String ERROR_ATTRIBUTE = "javax.servlet.error.exception";

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.web.access.AccessDeniedHandler"})
    public AccessDeniedHandler accessDeniedHandler() {
        return (request, response, exception) -> {
            if (!response.isCommitted()) {
                request.setAttribute(ERROR_ATTRIBUTE, (Object)exception);
                response.sendError(403);
            }
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.web.AuthenticationEntryPoint"})
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return (request, response, exception) -> {
            if (!response.isCommitted()) {
                request.setAttribute(ERROR_ATTRIBUTE, (Object)exception);
                response.sendError(401);
            }
        };
    }
}

