/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.fingerprint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import me.alidg.errors.FingerprintProvider;
import me.alidg.errors.HttpError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.DigestUtils;

public class Md5FingerprintProvider
implements FingerprintProvider {
    private static final Logger logger = LoggerFactory.getLogger(Md5FingerprintProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String generate(@NonNull HttpError httpError) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.write((OutputStream)outputStream, this.exceptionName(httpError));
            this.write((OutputStream)outputStream, System.currentTimeMillis());
            this.write((OutputStream)outputStream, System.nanoTime());
            String string = DigestUtils.md5DigestAsHex((byte[])outputStream.toByteArray());
            return string;
        }
        catch (Exception e) {
            logger.warn("Failed to generate a fingerprint for {}", (Object)httpError);
            return null;
        }
    }

    private String exceptionName(HttpError httpError) {
        return Optional.ofNullable(httpError.getOriginalException()).map(Object::getClass).map(Class::getName).orElse("no-exception");
    }

    private void write(OutputStream os, String toWrite) {
        try {
            os.write(toWrite.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(OutputStream os, long timestamp) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(0, timestamp);
            os.write(buffer.array());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

