/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import me.alidg.errors.Argument;

final class ConstraintViolationArgumentsExtractor {
    private static final Collection<String> IGNORE_ATTRIBUTES = Arrays.asList("groups", "payload", "message");

    private ConstraintViolationArgumentsExtractor() {
    }

    static List<Argument> extract(ConstraintViolation<?> violation) {
        List<Argument> args = violation.getConstraintDescriptor().getAttributes().entrySet().stream().filter(e -> !IGNORE_ATTRIBUTES.contains(e.getKey())).sorted(Map.Entry.comparingByKey()).map(e -> Argument.arg((String)e.getKey(), e.getValue())).collect(Collectors.toList());
        args.add(Argument.arg("invalid", violation.getInvalidValue()));
        args.add(Argument.arg("property", violation.getPropertyPath().toString()));
        return args;
    }
}

