/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.message;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.alidg.errors.Argument;

final class TemplateParser {
    private final Pattern pattern = Pattern.compile("(?<!\\\\)(\\{[^}^{]*})");

    TemplateParser() {
    }

    String parse(String template, List<Argument> arguments) {
        if (template == null || arguments == null || arguments.isEmpty()) {
            return template;
        }
        Matcher matcher = this.pattern.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            Object value = this.extractValue(placeholder, arguments);
            if (value == null) continue;
            matcher.appendReplacement(sb, value.toString());
        }
        matcher.appendTail(sb);
        return sb.toString().replace("\\{", "{").replace("\\}", "}");
    }

    private Object extractValue(String placeholder, List<Argument> arguments) {
        String variable = this.getPlaceholderVariable(placeholder);
        Optional<Argument> argument = arguments.stream().filter(a -> a.getName().equals(variable)).findFirst();
        if (argument.isPresent()) {
            return argument.map(this::argumentValue).get();
        }
        try {
            int index = Integer.parseInt(variable);
            return this.argumentValue(arguments.get(index));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getPlaceholderVariable(String placeholder) {
        return placeholder.substring(1, placeholder.length() - 1);
    }

    private Object argumentValue(Argument argument) {
        Object value = argument.getValue();
        return value == null ? "null" : value;
    }
}

