/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.mvc;

import java.util.Locale;
import java.util.Objects;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public abstract class ErrorsControllerAdvice {
    private final WebErrorHandlers errorHandlers;
    private final HttpErrorAttributesAdapter httpErrorAttributesAdapter;

    public ErrorsControllerAdvice(WebErrorHandlers errorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        this.errorHandlers = Objects.requireNonNull(errorHandlers, "Error handlers is required");
        this.httpErrorAttributesAdapter = Objects.requireNonNull(httpErrorAttributesAdapter, "Adapter is required");
    }

    @ExceptionHandler
    public ResponseEntity<?> handleException(Throwable exception, WebRequest webRequest, Locale locale) {
        HttpError httpError = this.errorHandlers.handle(exception, webRequest, locale);
        return ResponseEntity.status((HttpStatus)httpError.getHttpStatus()).body(this.httpErrorAttributesAdapter.adapt(httpError));
    }
}

