/*
 * Decompiled with CFR 0.152.
 */
package me.bardy.komponent.colour;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import me.bardy.komponent.colour.Color;
import me.bardy.komponent.colour.ColorKt;
import me.bardy.komponent.colour.EmptyColor;
import me.bardy.komponent.colour.NamedColor;
import me.bardy.komponent.colour.RGBColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lme/bardy/komponent/colour/ColourSerialiser;", "Lkotlinx/serialization/KSerializer;", "Lme/bardy/komponent/colour/Color;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "komponent"})
public final class ColourSerialiser
implements KSerializer<Color> {
    @NotNull
    private static final SerialDescriptor descriptor;
    @NotNull
    public static final ColourSerialiser INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Color deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        String string = StringsKt.removePrefix((String)decoder.decodeString(), (CharSequence)"#");
        int n = 16;
        boolean bl = false;
        int value = Integer.parseInt(string, CharsKt.checkRadix((int)n));
        if (value < 0) {
            return EmptyColor.INSTANCE;
        }
        NamedColor namedColor = NamedColor.Companion.from(value);
        return namedColor != null ? (Color)namedColor : (Color)new RGBColor(value);
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeString(ColorKt.toHexString(value.getValue()));
    }

    private ColourSerialiser() {
    }

    static {
        ColourSerialiser colourSerialiser;
        INSTANCE = colourSerialiser = new ColourSerialiser();
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Color", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.INT.INSTANCE));
    }
}

