/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.groovysh;

import groovy.lang.Binding;
import groovy.lang.Closure;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import me.bazhenov.groovysh.GroovyShellService;
import me.bazhenov.groovysh.SshTerminal;
import me.bazhenov.groovysh.TtyFilterOutputStream;
import org.apache.groovy.groovysh.Groovysh;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.codehaus.groovy.tools.shell.IO;

class GroovyShellCommand
implements Command {
    private final SshServer sshd;
    private final Map<String, Object> bindings;
    private final List<String> defaultScripts;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private Thread wrapper;
    private ChannelSession session;
    private final AtomicBoolean isChannelAlive;

    GroovyShellCommand(SshServer sshd, Map<String, Object> bindings, List<String> defaultScripts, AtomicBoolean isChannelAlive) {
        this.sshd = sshd;
        this.bindings = bindings;
        this.defaultScripts = defaultScripts;
        this.isChannelAlive = isChannelAlive;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession session, Environment env) throws IOException {
        this.session = session;
        TtyFilterOutputStream out = new TtyFilterOutputStream(this.out, this.isChannelAlive);
        TtyFilterOutputStream err = new TtyFilterOutputStream(this.err, this.isChannelAlive);
        IO io = new IO(this.in, (OutputStream)out, (OutputStream)err);
        io.setVerbosity(IO.Verbosity.DEBUG);
        final Groovysh shell = new Groovysh(this.createBinding(this.bindings, out, err), io);
        shell.setErrorHook((Closure)new Closure<Object>((Object)this){

            public Object call(Object ... args) {
                if (args[0] instanceof InterruptedIOException || args[0] instanceof SshException) {
                    shell.getRunner().setRunning(false);
                }
                return shell.getDefaultErrorHook().call(args);
            }
        });
        try {
            this.loadDefaultScripts(shell);
        }
        catch (Exception e) {
            GroovyShellCommand.createPrintStream(err).println("Unable to load default scripts: " + e.getClass().getName() + ": " + e.getMessage());
        }
        this.session.setAttribute(GroovyShellService.SHELL_KEY, (Object)shell);
        Runnable runnable = () -> {
            try {
                SshTerminal.registerEnvironment(env);
                shell.run("");
                this.callback.onExit(0);
            }
            catch (Error | RuntimeException e) {
                this.callback.onExit(-1, e.getMessage());
            }
        };
        this.wrapper = GroovyShellCommand.newThread(runnable, this.session);
        this.wrapper.start();
    }

    private static Thread newThread(Runnable r, ChannelSession session) {
        String address = session.getSession().getIoSession().getRemoteAddress().toString();
        String threadName = "GroovySh Client Thread: " + address;
        return new Thread(r, threadName);
    }

    private Binding createBinding(Map<String, Object> objects, OutputStream out, OutputStream err) throws UnsupportedEncodingException {
        Binding binding = new Binding();
        if (objects != null) {
            for (Map.Entry<String, Object> row : objects.entrySet()) {
                binding.setVariable(row.getKey(), row.getValue());
            }
        }
        binding.setVariable("out", (Object)GroovyShellCommand.createPrintStream(out));
        binding.setVariable("err", (Object)GroovyShellCommand.createPrintStream(err));
        binding.setVariable("activeSessions", (Object)new Closure<List<AbstractSession>>((Object)this){

            public List<AbstractSession> call() {
                return GroovyShellCommand.this.sshd.getActiveSessions();
            }
        });
        return binding;
    }

    private static PrintStream createPrintStream(OutputStream out) throws UnsupportedEncodingException {
        return new PrintStream(out, true, "utf8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultScripts(final Groovysh shell) {
        if (!this.defaultScripts.isEmpty()) {
            Closure defaultResultHook = shell.getResultHook();
            try {
                shell.setResultHook((Closure)new Closure<Groovysh>((Object)this){

                    public Groovysh call(Object ... args) {
                        return shell;
                    }
                });
                org.apache.groovy.groovysh.Command cmd = shell.getRegistry().find(":load");
                for (String script : this.defaultScripts) {
                    cmd.execute(Collections.singletonList(script));
                }
            }
            finally {
                shell.setResultHook(defaultResultHook);
            }
        }
    }

    public void destroy(ChannelSession channel) {
        this.wrapper.interrupt();
    }
}

