/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.groovysh;

import java.util.Objects;
import jline.UnixTerminal;
import org.apache.sshd.server.Environment;

public class SshTerminal
extends UnixTerminal {
    private static final ThreadLocal<Environment> env = new ThreadLocal();

    public int getWidth() {
        String columnsAsString = (String)this.retrieveEnvironment().getEnv().get("COLUMNS");
        try {
            if (SshTerminal.isNullOrEmpty(columnsAsString)) {
                return 80;
            }
            int columns = Integer.parseInt(columnsAsString);
            return columns > 0 ? columns : 80;
        }
        catch (NumberFormatException e) {
            return 80;
        }
    }

    public int getHeight() {
        String linesAsString = (String)this.retrieveEnvironment().getEnv().get("LINES");
        try {
            if (SshTerminal.isNullOrEmpty(linesAsString)) {
                return 24;
            }
            int lines = Integer.parseInt(linesAsString);
            return lines > 0 ? lines : 24;
        }
        catch (NumberFormatException e) {
            return 24;
        }
    }

    private Environment retrieveEnvironment() {
        return Objects.requireNonNull(env.get(), "Environment is not registered");
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    static void registerEnvironment(Environment environment) {
        env.set(environment);
    }
}

